#pragma once
#include "TextTools.h"

/*!
	O
*/
class CXMLTextParserException
{
public:
	CXMLTextParserException() {};
	CXMLTextParserException(CString error, int point)
	{
		m_error = error;
		m_point = point;
	};

	CString	m_error;
	int		m_point;
};

/*!
	^OIvV
*/
class CTagOption
{
public:
	CTagOption() {};
	CTagOption(LPSTR key, LPSTR data)
	{
		m_key = key;
		m_data = data;
	};

	LPSTR	m_key;
	LPSTR	m_data;
};

/*!
	z^
*/
class CTagOptionArray : public CArray<CTagOption> {};

/*!
	ȈՂwlk͊
	CWorkspaceNX̓ǂݏp
*/
class CXMLTextParser
{
public:
	CXMLTextParser(void);
	virtual ~CXMLTextParser(void);

	/////////////////////////////////////////////////////////////////////////////////////
	//	Jn
	/////////////////////////////////////////////////////////////////////////////////////
	//!	XL
	void StartScan(CString xml);

	//!	t@C擾
	CString LoadXmlFile(CString path);

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	^O
	/////////////////////////////////////////////////////////////////////////////////////
	//!	CfbNX̍쐬
	void BuildTagIndex();

	//!	Jn^O؂o
	int ParseNextTag();

	//!	f[^؂o
	void ParseData(CString &data);

	//!	^OIvV̉
	void ParseTagOption(LPSTR tag, CTagOptionArray &keys);

	/////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////
	//!	Jn^O
	virtual void OnStartTag(LPCSTR tag, CTagOptionArray &keys) {/* TRACE(_T("StartTag : %s\n"), tag); */};

	//!	I^O
	virtual void OnEndTag(LPCSTR tag) {/* TRACE(_T("EndTag : %s\n"), tag); */};

	//!	^O
	virtual void OnSpecialTag(LPCSTR tag) {/* TRACE(_T("SpecialTag : %s\n"), tag); */};

	//!	f[^
	virtual void OnData(LPCSTR data) {/* TRACE(_T("Data : %s\n"), data); */};

	/////////////////////////////////////////////////////////////////////////////////////
	//	c[
	/////////////////////////////////////////////////////////////////////////////////////
	//!	w肵܂ł؂o
	_inline int GetNextToken(CString &src, CString find, CString &token, int tokenStart = 0, int removeToken = 1);

	//!	̃^O擾
	_inline int GetNextTag(LPSTR *tag, LPSTR *data);

	//!	^O𕪗
	_inline void SplitTag(LPSTR tag, LPSTR *tagOption);

	//!	^O^Cv擾
	_inline int GetTagType(LPSTR *tag);

	//!	w肵܂ł؂o
//	_inline int GetNextToken(LPSTR *src, LPSTR splitter, LPSTR *token);

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	f[^
	CString		m_xmlData;

	//!	f[^
	int			m_dataLen;

	//!	GXP[v
	CTextEscape	m_escape;

	//!	^Oʒu
	CArray<int>	m_tagIndexes;

	//!	f[^obt@
	LPSTR		m_lpXml;

	//!	^O
	CTypedPtrArray<CPtrArray,LPSTR>	m_tags;

	//!	f[^
	CTypedPtrArray<CPtrArray,LPSTR>	m_datas;

	//!	JE^
	int			m_tagCounter;
};
