#pragma once
#include "BinaryData.h"

#define	STACK_MEMORY_SIEZ	256

/*!
	TCY܂ŃmۂȂ^
*/
class CStackString
{
public:
	CStackString(void);
	CStackString(const  CStackString &other);
	CStackString(const  CString &other);
	CStackString(const  LPSTR other);
	virtual ~CStackString(void);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Rs[
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CStackString
	void operator=(const CStackString &other);

	//!	CString
	void operator=(const CString &other);

	//!	LPCSTR
	void operator=(LPCSTR other);

	//!	char
	void operator=(LPSTR other);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CString
	operator CString()
	{
		return m_strBuffer;
	}

	//!	LPCSTR
	operator LPCSTR()
	{
		return m_strBuffer;
	}

	//!	LPSTR
	operator LPSTR()
	{
		return m_strBuffer;
	}

	//!	[]
	unsigned char operator [](int index)
	{
		return(m_strBuffer[index]);
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//	r
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CStackString
	int operator==(const CStackString &other);

	//!	CString
	int operator==(const CString &other);

	//!	LPCSTR
	int operator==(LPCSTR other);

	//!	LPCSTR
	int operator==(LPSTR other);

	//!	ʂɔr
	int Compare(const CStackString &other);

	//!	r
	int CompareNoCase(const CStackString &other);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	ǉ
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CStackString
	CStackString operator+(const CStackString &other);

	//!	CString
	CStackString operator+(const CString &other);

	//!	LPCSTR
	CStackString operator+(LPCSTR other);

	//!	LPCSTR
	CStackString operator+(LPSTR other);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	ǉ()
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	CStackString
	void operator+=(const CStackString &other);

	//!	CString
	void operator+=(const CString &other);

	//!	LPCSTR
	void operator+=(LPCSTR other);

	//!	LPCSTR
	void operator+=(LPSTR other);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	폜
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	폜
	CStackString Delete(int index, int count = 1);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Trim
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	E폜
	CStackString &TrimRight();

	//!	폜
	CStackString &TrimLeft();

	//!	󔒂폜
	CStackString &Trim()
	{
		return(TrimLeft().TrimRight());
	}

	//////////////////////////////////////////////////////////////////////////////////////////
	//	Left, Right, Mid
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	E폜
	CStackString Right(int count);

	//!	폜
	CStackString Left(int count);

	//!	wʒu擾
	CStackString Mid(int index, int count = -1);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	
	int Find(LPSTR find, int start = 0);

	//!	u
	int Replace(LPSTR oldTok, LPSTR newTok);

	//////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	擾
	const int GetLength()
	{
		return m_strLen;
	}

	//!	empty
	const int IsEmpty()
	{
		return !m_strLen;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	m
	void ReSize(int size);

	//!	Rs[
	void Copy(LPCSTR src, int len);

	//!	ǉ
	void Append(LPCSTR src, int len);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////
	//!	|C^
	LPSTR		m_strBuffer;

	//!	̒
	int			m_strLen;

	//!	mۃ
	char		m_stackBuf[STACK_MEMORY_SIEZ];

	//!	q[v
	CBinaryData	m_heapBuf;
	
};
