#pragma once
#include "IStringHelper.h"
#include "WorkspaceNodeWalker.h"
#include "WorkspaceKeyPairArray.h"
#include "SimpleArrayTemplate.h"
#include "WorkspaceString.h"

#define	NODE_NAME_LEN	128	//	m[hWobt@
#define	NODE_GROW_SIZE	5	//	TCY

//	錾Ă
class CWorkspaceNode;

/*!
	m[hz^̐錾
*/
class CWorkspaceNodeArray : public CSimpleArrayTemplate<CWorkspaceNode,
									CWorkspaceNode&,
									CSimpleArrayTemplateItmeConstructor<CWorkspaceNode>,
									NODE_GROW_SIZE>
{
};


/*!
	[NXy[X̃m[hێNX
*/
class CWorkspaceNode
{
public:
	CWorkspaceNode();
	CWorkspaceNode(LPCU8STR name);
	CWorkspaceNode(const CWorkspaceNode &othe);
	~CWorkspaceNode(void);

	/***********************************************************************************
		Ȃ
	***********************************************************************************/
	//!	CArrayŗp邽߂́ARs[Zq
	void operator=(const CWorkspaceNode &other);

	//!	Sf[^NA
	void Clear(void);

	//!	m[h̐ݒ
	void SetNodeName(LPCU8STR name) { m_nodeName = name; };

	//!	m[h̎擾
	LPCU8STR GetNodeName() const { return(m_nodeName); }; 


	/***********************************************************************************
		KeyɊւ鏈
	***********************************************************************************/
	//!	f[^̐ݒ
	void SetKeyData(LPCU8STR key, LPCU8STR data,int noCase);

	//!	f[^̎擾
	LPCU8STR GetKeyData(LPCU8STR key, LPCU8STR defaultData, int noCase);

	//!	f[^̍폜
	void DeleteKey(LPCU8STR key);

	//!	L[擾
	int GetKeyCount();

	//!	SẴL[𕶎ƂĎ擾
	int GetAllKeyPair(IStringArrayPtr keys, IStringArrayPtr datas);


	//!	L[܂Ƃ߂Đݒ
	void ClearAndSetKeys(CUTF8StringArray &keys, CUTF8StringArray &datas);

	/***********************************************************************************
		Tum[hɊւ鏈
	***********************************************************************************/
	//!	Tum[hw܂߂Č(Βǉ)
	CWorkspaceNode *GetSubNode(CWorkspaceNodeWalker &path, CUTF8String &key);

	//!	m[h폜
	void DeleteNode(LPCU8STR name);

	//!	Tum[h𓾂
	int GetSubNodeCount();

	//!	SẴTum[h𕶎ƂĎ擾
	int GetAllSubNode(IStringArrayPtr list);


	/***********************************************************************************
		o͂Ɋւ鏈
	***********************************************************************************/
	//!	Tum[h𖼑O擾E쐬
	CWorkspaceNode *GetSubNodeByName(LPCU8STR name, int errorIfExist = FALSE);

	//!	Tum[hCfbNXŎ擾
	CWorkspaceNode *GetSubNodeByIndex(int index);

	//!	L[CfbNXŎ擾
	CWorkspaceKeyPair *GetKeyByIndex(int index);

protected:
	/***********************************************************************************
		KeyɊւ鏈
	***********************************************************************************/
	//!	Key̌
	int FindKeyIndex(LPCU8STR key,int noCase);

	/***********************************************************************************
		Tum[hɊւ鏈
	***********************************************************************************/
	//!	Tum[h
	int FindSubNodeIndex(LPCU8STR name);

protected:
	//!	̃m[h̎f[^
	CWorkspaceKeyPairArray			m_keyData;

	//!	Tum[g
	CWorkspaceNodeArray				m_subNode;

	//!	̃m[h̖O
	CWorkspaceString<NODE_NAME_LEN>	m_nodeName;
};

