#pragma once

#include "IServerTool.h"
#include "SettingManager.h"
#include "NewConnectionQueue.h"
#include "ListenerManager.h"
#include "ConnectionManager.h"
#include "ServerStatusManager.h"
#include "ResponseManager.h"
#include "FilterManager.h"
#include "PathManager.h"
#include "MimeTypeManager.h"
#include "LogManager.h"
#include "ServerTextManager.h"
#include "ServerInfoManager.h"
#include "CGIManager.h"
#include "InterfaceManager.h"

class CServer : protected IServerTool, protected IServerControl
{
public:
	CServer(void);
	virtual ~CServer(void);

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerControlC^[tF[X擾
	IServerControlPtr GetIServerControl() { return this; };

protected:
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	C^[tF[X擾
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	IServerToolC^[tF[X擾
	IServerToolPtr GetIServerTool() { return this; };

	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerControl
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o̊Jn
	virtual void StartServer();

	//!	T[o̒~
	virtual void StopServer();

	//!	݂̐ڑXe[^X擾
	virtual CWorkspaceAccess GetConnectionInfo() { return CWorkspaceAccess(); };


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	IServerTool
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[oXe[^X̕ύX
	virtual void WriteSystemLog(LPCSTR callerName, int statusCode, LPCSTR statusInfo, int autoOffTime = -1);

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusInt(LPCSTR statusName, int status, LPCSTR statusInfo = "");

	//!	T[oXe[^X̕ύX
	virtual void SetServerStatusStr(LPCSTR statusName, LPCSTR status, LPCSTR statusInfo = "");

	//!	[NXy[Xւ̃ANZX擾
	virtual int GetServerWorkspaceAccess(IWorkspaceAccessRefPtr accessRef, LPCSTR type, LPCSTR section);

	//!	C^tF[Xo^
	virtual int RegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface);

	//!	C^[tF[Xo^
	virtual int UnRegisterManagerInterface(LPCSTR interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface);

	//!	C^tF[Xw肵Ď擾
	virtual void *GetManagerInterface(LPCSTR managerName, int interfaceVersion);


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	ʃNX
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X}l[W
	CInterfaceManager		m_interfaceManager;

	//!	ݒ}l[W
	CSettingManager			m_settingManager;

	//!	Xe[^X}l[W
	CServerStatusManager	m_statusManager;

	//!	T[o}l[W
	CServerInfoManager		m_serverInfoManager;


	//!	Xi
	CListenerManager		m_listenerManager;

	//!	X|X}l[W
	CResponseManager		m_responseManager;

	//!	tB^}l[W
	CFilterManager			m_filterManager;

	//!	ڑ}l[W
	CConnectionManager		m_connectionManager;


	//!	pX}l[W
	CPathManager			m_pathManager;

	//!	MimeType}l[W
	CMimeTypeManager		m_mineTypeManager;

	//!	CGI}l[W
	CCGIManager				m_cgiManager;

	//!	T[oeLXg}l[W
	CServerTextManager		m_serverTextManager;

	//!	ANZXO}l[W
	CLogManager				m_logManager;


	/////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[os
	CInterlockCounter		m_serverRunning;
};
