#include "StdAfx.h"
#include "ServerInfoManager.h"
#include "Dir.h"
#include "IPAddress.h"

CServerInfoManager::CServerInfoManager(void)
{
	m_serverInfo = m_infoRoot.GetAccess("ServerInfo");
}

CServerInfoManager::~CServerInfoManager(void)
{
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CServerInfoManager::Start(CIServerToolWrap serverTool)
{
	if(m_init)
		return;
	m_init = 1;

	//	Rs[A
	m_serverTool = serverTool;

	//	ݒ擾
	m_setting = m_serverTool.GetManagerSetting(m_setting.GetSettingName());

	//	T[o
	m_serverInfo.SetServerName(m_setting.GetServerName(SERVER_NAME));

	//	o[W
	m_serverInfo.SetServerVersion(m_setting.GetServerVersion(SERVER_VERSION));

	//	T[oVOj`
	m_serverInfo.SetServerSignature(m_setting.GetServerSignature(SERVER_VERSION_STRING));

	//	T[o[g
	m_serverInfo.SetServerRoot(CPathTools::GetAppPath());

	//	T[oAhX
	CIPAddress	localhost = CIPAddress::GetLocalhost();
	m_serverInfo.SetServerAddress((CString)localhost);

	//	T[o
	m_serverInfo.SetServerHostName(localhost.GetHostName());

	//	ǂݍݐp
	m_infoRoot.SetReadOnly(TRUE);

	//	C^[tF[Xo^
	m_serverTool.RegisterManagerInterface(CIServerInfoManagerWrap::GetInterfaceName(), this);
}

/*!
	~
*/
void CServerInfoManager::Stop()
{
	if(!m_init)
		return;
	m_init = 0;

	//	C^[tF[Xo^
	m_serverTool.UnRegisterManagerInterface(CIServerInfoManagerWrap::GetInterfaceName(), this);
}

