#pragma once
#include "ServerInfo.h"
#include "ServerToolWrap.h"
#include "SyncObject.h"
#include "Settings.h"
#include "IServerInfoManager.h"

class CServerInfoManager : public IManagerInterface, public IServerInfoManager
{
public:
	CServerInfoManager(void);
	virtual ~CServerInfoManager(void);

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IServerInfoManager
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual void *GetInterface(int ifVersion)
	{
		if(ifVersion != CIServerInfoManagerWrap::GetInterfaceVersion())
			return(NULL);
		return(GetIServerInfoManager());
	};

	//!	I[o[[hʒm
	virtual void NotifyOverload() {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	ICGIManager
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	T[o擾
	virtual void GetServerInfo(IWorkspaceAccessRefPtr serverInfoRef)
	{
		_GetServerInfo().FillIWorkspaceAccessRef(serverInfoRef);
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual IServerInfoManagerPtr GetIServerInfoManager() { return this; };

	//!	擾
	CServerInfo _GetServerInfo() { return m_serverInfo; };

	///////////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter			m_init;

	//!	T[oc[
	CIServerToolWrap			m_serverTool;

	//!	ێ
	CWorkspace					m_infoRoot;

	//!	T[o
	CServerInfo					m_serverInfo;

	//!	ݒ
	CServerInfoManagerSetting	m_setting;
};
