#include "StdAfx.h"
#include "WorkspaceXMLReader.h"


CWorkspaceXMLReader::CWorkspaceXMLReader(void)
{
}

CWorkspaceXMLReader::~CWorkspaceXMLReader(void)
{
}

void CWorkspaceXMLReader::LoadFromFile(CWorkspaceNode *root, CString path, CString workspaceClassType)
{
	m_curNode = root;
	m_inKeyLeaf = 0;
	m_depth.RemoveAll();
	m_workspaceClassType = workspaceClassType;

	StartScan(LoadXmlFile(path));

	//	ŏI`FbN
	if(m_depth.GetCount())
			throw CXMLTextParserException(_T("SubnodeĂ܂"), m_dataLen - m_xmlData.GetLength());
}

/*!
	XMLǂݍ(throw CXMLTextParserException)
*/
void CWorkspaceXMLReader::FromString(CWorkspaceNode *root, CString str, CString workspaceClassType)
{
	m_curNode = root;
	m_inKeyLeaf = 0;
	m_depth.RemoveAll();
	m_workspaceClassType = workspaceClassType;

	StartScan(str);

	//	ŏI`FbN
	if(m_depth.GetCount())
			throw CXMLTextParserException(_T("SubnodeĂ܂"), m_dataLen - m_xmlData.GetLength());
}


/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn^O
*/
void CWorkspaceXMLReader::OnStartTag(CString tag, CTagOptionArray &keys)
{
	//	`FbN
	if(m_inKeyLeaf)
		throw CXMLTextParserException(_T("KeyɃ^O͋Lqł܂"), m_dataLen - m_xmlData.GetLength());

	//	^O
	if(tag == _T("Subnode") || tag == _T("Node"))
	{
		//	`FbN
		if(keys.GetSize() != 1 || keys[0].m_key != _T("name"))
			throw CXMLTextParserException(_T("Subnode^Oł"), m_dataLen - m_xmlData.GetLength());

		//	ŏʁH
		if(m_depth.GetCount() == 0)
		{
			if(keys[0].m_data != m_workspaceClassType)
				throw CXMLTextParserException(_T("ŏSubnode݂܂"), m_dataLen - m_xmlData.GetLength());
			else
				m_depth.AddHead(m_curNode);
		}
		else
		{
			//	ǉ
			m_curNode = m_curNode->AddNewSubNode(keys[0].m_data); 
			if(m_curNode == NULL)
				throw CXMLTextParserException(_T("Subnode݂܂"), m_dataLen - m_xmlData.GetLength());
			m_depth.AddHead(m_curNode);
		}
	}
	else if(tag == _T("Key"))
	{
		//	`FbN
		if(m_depth.GetCount() == 0 || keys.GetSize() != 1 || keys[0].m_key != _T("name"))
			throw CXMLTextParserException(_T("Key^Oł"), m_dataLen - m_xmlData.GetLength());
		m_inKeyLeaf = 1;
		m_keyName = keys[0].m_data;
	}
	else if(tag == _T("Leaf"))
	{
		//	`FbN
		if(m_depth.GetCount() == 0 || keys.GetSize() != 1 || keys[0].m_key != _T("key"))
			throw CXMLTextParserException(_T("Leaf^Oł"), m_dataLen - m_xmlData.GetLength());
		m_inKeyLeaf = 1;
		m_keyName = keys[0].m_data;
	}
	else if(tag == _T("CWorkspaceClass") || tag == _T("CConfigClass"))
	{
		//	`FbN
		if(m_depth.GetCount() != 0 || keys.GetSize() != 1 || keys[0].m_key != _T("type"))
			throw CXMLTextParserException(_T("CWorkspaceClass^Oł"), m_dataLen - m_xmlData.GetLength());

		//	NX`FbN
		if(m_workspaceClassType !=  keys[0].m_data)
			throw CXMLTextParserException(_T("[NXy[XقȂ܂A[hł܂"), m_dataLen - m_xmlData.GetLength());
	}
	else
	{
		throw CXMLTextParserException(_T("ȃ^Oł"), m_dataLen - m_xmlData.GetLength());
	}
}

/*!
	I^O
*/
void CWorkspaceXMLReader::OnEndTag(CString tag)
{
	//	^O
	if(tag == _T("Subnode") || tag == _T("Node"))
	{
		//	`FbN
		if(m_inKeyLeaf)
			throw CXMLTextParserException(_T("KeyɃ^O͋Lqł܂"), m_dataLen - m_xmlData.GetLength());

		//	m[h[`FbN
		if(m_depth.GetCount() <= 0)
			throw CXMLTextParserException(_T("Subnode^ȎΉُł"), m_dataLen - m_xmlData.GetLength());

		m_depth.RemoveHead();

		//	ŏʁH
		if(m_depth.GetCount() != 0)
			m_curNode = m_depth.GetHead();
		else
			m_curNode = NULL;
	}
	else if(tag == _T("Key") || tag == _T("Leaf"))
	{
		//	`FbN
		if(!m_inKeyLeaf)
			throw CXMLTextParserException(_T("ȏI^Oł"), m_dataLen - m_xmlData.GetLength());
		m_inKeyLeaf = 0;
	}
	else if(tag == _T("CWorkspaceClass") || tag == _T("CConfigClass"))
	{
		//	`FbN
		if(m_inKeyLeaf)
			throw CXMLTextParserException(_T("KeyɃ^O͋Lqł܂"), m_dataLen - m_xmlData.GetLength());
	}
	else
	{
		throw CXMLTextParserException(_T("ȃ^Oł"), m_dataLen - m_xmlData.GetLength());
	}
}

/*!
	^O
*/
void CWorkspaceXMLReader::OnSpecialTag(CString tag)
{
}

/*!
	f[^
*/
void CWorkspaceXMLReader::OnData(CString data)
{
	if(m_inKeyLeaf)
	{
		m_curNode->SetKeyData(m_keyName, data, FALSE);
	}
	else
	{
		data.Trim();
		if(!data.IsEmpty())
			throw CXMLTextParserException(_T("ȃf[^ł"), m_dataLen - m_xmlData.GetLength());
	}
}
