#include "StdAfx.h"
#include "CGIResponse.h"
#include "Dir.h"
#include "Threadskeleton.h"


#define	MAX_HEADER_LENGTH	8192
#define	MAX_STDERR_LENGTH	8192

//!	W[
static TCHAR _MODULE_NAME[] = _T("CGIResponse");

CCGIResponse::CCGIResponse(CICGIManagerWrap cgiManager)
{
	m_cgiManager = cgiManager;
	m_cgiReadTimeout = m_cgiManager.GetCGIManagerSetting().GetCGIDataReadTimeoutTime();
	m_cgiWriteTimeout = m_cgiManager.GetCGIManagerSetting().GetCGIDataWriteTimeoutTime();
}

CCGIResponse::~CCGIResponse(void)
{
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	(OցI)
*/
void CCGIResponse::_ResponseStart(CIConnectionToolWrap responseContext)
{
}

/*!
	~(OցI)
*/
void CCGIResponse::_ResponseStop(CIConnectionToolWrap responseContext)
{
	//	IĂ
	m_cgiProcess.TerminateSubProcess();
}

/*!
	X|X擾
*/
LPCTSTR CCGIResponse::GetResponseName()
{
	return _MODULE_NAME;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	X|X
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgwb_ݒ
*/
void CCGIResponse::_ResponseSetRequest(CIConnectionToolWrap responseContext)
{
	//	^[Qbg擾
	CContextTargetInfo targetInfo = responseContext.GetContxet().GetTargetInfo();

	//	H
	if(!targetInfo.GetTargetIsExist())
		throw CServerResponseException(404, _T("w肳ꂽt@C݂͑܂"));

	//	t@CH
	if(targetInfo.GetTargetIsDirectory() || targetInfo.GetTarget().Right(1) == "\\")
		throw CConnectionErrorException(_T("fBNgt@CƂĕ\悤Ƃ܂"));

	//	CGIR}h擾
	CWorkspace	commandTemp;
	CCGICommand	command = commandTemp.GetAccess("CGICommand");
	if(!m_cgiManager.GetCGICommand(targetInfo.GetTarget(), command))
		throw CConnectionErrorException(_T("CGĨR}h擾Ɏs܂"));

	//	T[oݒ
	m_cgiProcess.AddServerInfoToEnv(responseContext.GetIServerTool().GetIServerInfoManager().GetServerInfo());

	//	NGXgݒ
	m_cgiProcess.AddRequestInfoToEnv(responseContext.GetContxet());

	//	R}h擾
	CString cgiCommand = m_cgiProcess.CreateCGICommandLine(responseContext.GetContxet(), command);

	//	R}hs
	if(m_cgiProcess.RunSubProcess(cgiCommand, CPathTools::PathToDir(targetInfo.GetTarget()), responseContext.GetContxet().GetName()))
		throw CConnectionErrorException(_T("CGIvZX̋NɎs܂"));
}

/*!
	NGXg{fBݒ(JԂ)
*/
void CCGIResponse::_ResponseSetRequestBody(CIConnectionToolWrap responseContext, CBinaryData &body)
{
	//	]s
	if(m_cgiProcess.WriteStdIn(body, responseContext.GetIConnectionThreadStatus()->GetBreakEvent(), m_cgiWriteTimeout) <= 0)
		throw CConnectionErrorException(_T("CGIvZXւ̃f[^]Ɏs܂"));
}


/*!
	X|X
*/
void CCGIResponse::_ResponseBuildResponse(CIConnectionToolWrap responseContext)
{
	CContextResponseInfo	responseInfo = responseContext.GetContxet().GetResponseInfo();

	//	obt@
	CString header;
	CBinaryData	readBuf;
	m_cgiHeaderBuffer.ReSize(0);

	//	CGIwb_҂
	while(1)
	{
		if(m_cgiProcess.ReadStdOut(readBuf, MAX_HEADER_LENGTH, responseContext.GetIConnectionThreadStatus()->GetBreakEvent(), m_cgiReadTimeout) <= 0)
			ThrowCGINoHeaderError();

		//	ǉ
		m_cgiHeaderBuffer.AppendBinary(readBuf);

		//	wb_o
		header = m_cgiProcess.GetHeaderBlock(m_cgiHeaderBuffer);
		if(!header.IsEmpty())
			break;

		//	TCY`FbN
		if(m_cgiHeaderBuffer.GetSize() >= MAX_HEADER_LENGTH)
			ThrowCGINoHeaderError();
	}

	//	CGIwb_
	CWorkspace		cgiHeaderRoot;
	CCGIHeader		cgiHeader = cgiHeaderRoot.GetAccess("CGIHeader");
	m_cgiProcess.ParseCGIHeader(header, cgiHeader);

	//	ړ?
	if(cgiHeader.GetLocation() != "")
	{
		//	ړ
		CServerResponseException	exception(301, cgiHeader.GetLocation() + " ɈړĂ");
		exception.AddAdditionalHeader("Location", cgiHeader.GetLocation());
		throw exception;
	}
	
	//	ContentType͏o͂ĂH	
	if(cgiHeader.GetContentType() != "")
		responseInfo.GetResponseOption().SetContentType(cgiHeader.GetContentType());
	else
		ThrowCGINoHeaderError();

	//	ȃXe[^XH
	if(cgiHeader.GetStatus() != 0)
	{
		if(cgiHeader.GetStatus() < 100 || cgiHeader.GetStatus() >= 600)
			throw CConnectionErrorException(_T("CGIُȃXe[^XR[ho͂܂"));
		responseInfo.SetResponseCode(cgiHeader.GetStatus());
	}
	else
		responseInfo.SetResponseCode(200);

	//	TCYwH
	if(cgiHeader.GetContentLength() > 0)
		responseInfo.GetResponseOption().SetContentLength(cgiHeader.GetContentLength());
	else
		responseInfo.GetResponseOption().ClearContentLength();

	//	gIvVݒ
	responseInfo.SetCGIHeader(cgiHeader.GetExtraHeader());
}

/*!
	X|Xwb_擾
*/
void CCGIResponse::_ResponseGetResponse(CIConnectionToolWrap responseContext)
{
	//	ƂȂ
}

/*!
	X|X{fB擾
*/
int CCGIResponse::_ResponseGetResponseBody(CIConnectionToolWrap responseContext, CBinaryData &body, int blockSize)
{
	//	wb_ǂݍݎ̎co
	if(m_cgiHeaderBuffer.GetSize() > 0)
	{
		body.ReSize(0);
		body.AppendBinary(m_cgiHeaderBuffer);
		m_cgiHeaderBuffer.Empty();
		return(body.GetSize());
	}

	//	ǂݏo
	int ret = m_cgiProcess.ReadStdOut(body, blockSize, responseContext.GetIConnectionThreadStatus()->GetBreakEvent(), m_cgiReadTimeout);
	if(ret < 0)
		throw CConnectionErrorException(_T("CGIvZX̃f[^]Ɏs܂"));

	return(ret);
}

//////////////////////////////////////////////////////////////////////////////////////////////
//	c[֐
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	CGING[o
*/
void CCGIResponse::ThrowCGINoHeaderError()
{
	//	\ȂSTDERRo
	CBinaryData	err;
	if(m_cgiProcess.PeekStdErr(err, MAX_STDERR_LENGTH) > 0)
		throw CServerResponseException(500, _T("CGIwb_o͂܂ł"), err.GetCString());

	//	tȂ
	throw CServerResponseException(500, _T("CGIwb_o͂܂ł"));
}


//////////////////////////////////////////////////////////////////////////////////////////////
//	擾
//////////////////////////////////////////////////////////////////////////////////////////////
/*!
	̃ACeH
*/
int CCGIResponseFactory::_ResponseFactoryIsYourRequest(CContext context)
{
	//	CGILH
	if(!context.GetTargetInfo().GetPathInfo().GetOption().GetEnableCGI())
		return(0);

	//	CGI?
	return m_cgiManager.TargetIsCGI(context.GetTargetInfo().GetTarget());
}
