#pragma once
#include "responsebase.h"
#include "CGIManager.h"
#include "CGIProcess.h"
#include "SyncObject.h"

class CCGIResponse :
	public CResponseBase
{
public:
	CCGIResponse(CICGIManagerWrap cgiManager);
	virtual ~CCGIResponse(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	(OցI)
	virtual void _ResponseStart(CIConnectionToolWrap responseContext);

	//!	~(OցI)
	virtual void _ResponseStop(CIConnectionToolWrap responseContext);

	//!	X|X擾
	virtual LPCTSTR GetResponseName();

	//!	폜
	virtual void ResponseDelete() { delete this; };

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_ݒ
	virtual void _ResponseSetRequest(CIConnectionToolWrap responseContext);

	//!	NGXg{fBݒ(JԂ)
	virtual void _ResponseSetRequestBody(CIConnectionToolWrap responseContext, CBinaryData &body);

	//!	X|X
	virtual void _ResponseBuildResponse(CIConnectionToolWrap responseContext);

	//!	X|Xwb_擾
	virtual void _ResponseGetResponse(CIConnectionToolWrap responseContext);

	//!	X|X{fB擾
	virtual int _ResponseGetResponseBody(CIConnectionToolWrap responseContext, CBinaryData &body, int blockSize);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	c[֐
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	CGING[o
	void ThrowCGINoHeaderError();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	CGI}l[W
	CICGIManagerWrap	m_cgiManager;

	//!	CGIvZX
	CCGIProcess		m_cgiProcess;

	//!	ǂݍ݃^CAEg
	int				m_cgiReadTimeout;

	//!	݃^CAEg
	int				m_cgiWriteTimeout;

	//!	CGIwb_pobt@
	CBinaryData		m_cgiHeaderBuffer;
};



/*!
	CGI X|Xt@Ng
*/
class  CCGIResponseFactory :
	public CResponseFactoryBase
{
public:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void ResponseFactoryStart(CIServerToolWrap serverTool)
	{
		m_cgiManager = serverTool.GetICGIManager();
	};

	//!	폜
	virtual void ResponseFactoryDelete()
	{
		delete this;
	};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃ACeH
	virtual int _ResponseFactoryIsYourRequest(CContext context);

	//!	X|X擾
	virtual IResponsePtr _ResponseFactoryGetResponse()
	{
		return new CCGIResponse(m_cgiManager.GetICGIManager());
	};

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	CGI}l[W
	CICGIManagerWrap	m_cgiManager;

};
