#pragma once
#include "ifilter.h"
#include "ServerToolWrap.h"
#include "BinaryData.h"
#include "ConnectionToolWrap.h"



class CFilterBase :
	public IFilter
{
public:
	virtual ~CFilterBase(void) {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void FilterStart(IConnectionToolPtr filterContext) { _FilterStart(filterContext); };

	//!	tB^擾
	virtual LPCTSTR GetFilterName() = 0;

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	NGXgM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_
	virtual void FilterRequestHeader(IConnectionToolPtr filterContext) { _FilterRequestHeader(filterContext); };

	//!	{fBMAJԂ(throw)
	virtual void FilterRequestBody(IConnectionToolPtr filterContext, IBinaryDataPtr body) { _FilterRequestBody(filterContext, CBinaryData(body)); };

	//!	M
	virtual void FilterEndRequest(IConnectionToolPtr filterContext) { _FilterEndRequest(filterContext); };

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|X
	virtual void FilterBuildResponse(IConnectionToolPtr filterContext) { _FilterBuildResponse(filterContext); };

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|XM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_
	virtual void FilterResponseHeader(IConnectionToolPtr filterContext) { _FilterResponseHeader(filterContext); };

	//!	{fB𑗐MAJԂ(throw)
	virtual void FilterResponseBody(IConnectionToolPtr filterContext, IBinaryDataPtr body) { _FilterResponseBody(filterContext, CBinaryData(body)); };

	//!	M
	virtual void FilterEndResponse(IConnectionToolPtr filterContext) { _FilterEndResponse(filterContext); };

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	T[oX|XM(O)
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_(OցI)
	virtual void FilterServerResponse(IConnectionToolPtr filterContext, IBinaryDataPtr body)  { _FilterServerResponse(filterContext, CBinaryData(body)); };

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	~
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	ؒf
	virtual void FilterStop(IConnectionToolPtr filterContext)  { _FilterStop(filterContext); };

	//!	폜
	virtual void FilterDelete() { _FilterDelete(); };

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void _FilterStart(CIConnectionToolWrap filterContext) {};

	//!	폜
	virtual void _FilterDelete() {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	NGXgM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_
	virtual void _FilterRequestHeader(CIConnectionToolWrap filterContext) {};

	//!	{fBMAJԂ(throw)
	virtual void _FilterRequestBody(CIConnectionToolWrap filterContext, CBinaryData &body) {};

	//!	M
	virtual void _FilterEndRequest(CIConnectionToolWrap filterContext) {};


	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|X
	virtual void _FilterBuildResponse(CIConnectionToolWrap filterContext) {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|XM
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_
	virtual void _FilterResponseHeader(CIConnectionToolWrap filterContext) {};

	//!	{fB𑗐MAJԂ(throw)
	virtual void _FilterResponseBody(CIConnectionToolWrap filterContext, CBinaryData &body) {};

	//!	M
	virtual void _FilterEndResponse(CIConnectionToolWrap filterContext) {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	T[oX|XM(O)
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	X|Xwb_(OցI)
	virtual void _FilterServerResponse(CIConnectionToolWrap filterContext, CBinaryData &body) {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	~
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	ؒf
	virtual void _FilterStop(CIConnectionToolWrap filterContext) {};

};
