#pragma once

#include "IFilter.h"
#include "ServerToolWrap.h"
#include "SyncObject.h"
#include "ModuleInterface.h"
#include "IManagerInterface.h"

//!	C^tF[X
#define	FILTER_MANAGER_INTERFACE_NAME	"IFilterManager"

//!	C^tF[Xo[W
#define	FILTER_MANAGER_INTERFACE_VER	1


//!	tB^AC
class CFilterArray : public CArray<CIFilterWrapper> {};

//!	tB^t@NgAC
class CFilterFactoryArray : public CArray<CIFilterFactoryWrapper> {};


/*!
	tB^[}l[WC^tF[X
*/
class IFilterManager
{
public:
	//!	tB^z擾
	virtual void GetFilterArray(CFilterArray &filters) = 0;
};
typedef IFilterManager* IFilterManagerPtr;


/*!
	tB^[}l[W
*/
class CFilterManager : public IManagerInterface, public IFilterManager
{
public:
	CFilterManager(void);
	virtual ~CFilterManager(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	EI
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	Jn
	void Start(CIServerToolWrap serverTool);

	//!	~
	void Stop();

protected:
	///////////////////////////////////////////////////////////////////////////////////////////
	//	IManagerInterface
	///////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual void *GetInterface(int ifVersion)
	{
		if(ifVersion != FILTER_MANAGER_INTERFACE_VER)
			return(NULL);
		return(GetIFilterManager());
	};

	//!	I[o[[hʒm
	virtual void NotifyOverload() {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterManager
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^z擾
	virtual void GetFilterArray(CFilterArray &filters);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	⏕
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	C^tF[X擾
	virtual IFilterManagerPtr GetIFilterManager() { return this; };

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tO
	CInterlockCounter	m_init;

	//!	NeBJZNV
	CCriticalSection	m_scopeLock;

	//!	T[oc[
	CIServerToolWrap			m_serverTool;

	//!	t@Ng
	CFilterFactoryArray	m_filterFactorys;
};

