#pragma once
#include "FilterBase.h"
#include "FilterFactoryBase.h"
#include "Settings.h"
#include "SyncObject.h"

class CIndexFilter :
	public CFilterBase
{
public:
	CIndexFilter(void);
	virtual ~CIndexFilter(void);

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void _FilterFactoryStart(CIServerToolWrap serverTool);

	//!	~
	virtual void FilterFactoryStop();

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterBase
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	virtual LPCTSTR GetFilterName();

	//!	NGXgwb_
	virtual void _FilterRequestHeader(CIConnectionToolWrap filterContext);

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection			m_scopeLock;

	//!	tO
	CInterlockCounter			m_init;

	//!	T[oc[
	CIServerToolWrap					m_serverTool;

	//!	ݒ
	CIndexFilterSetting			m_setting;

	//!	CfbNXt@C
	CStringArray				m_indexFiles;

	//!	ړ[h
	int							m_moveMode;
};


class CIndexFilterFactory :
	public CFilterFactoryBase
{
public:
	CIndexFilterFactory(void) {};
	virtual ~CIndexFilterFactory(void) {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	IFilterFactory
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^擾
	IFilterPtr FilterFactoryGetFilter()
	{
		return &m_filter;
	};

	//!	
	virtual void _FilterFactoryStart(CIServerToolWrap serverTool)
	{
		m_filter._FilterFactoryStart(serverTool);
	}

	//!	~
	virtual void _FilterFactoryStop()
	{
		m_filter.FilterFactoryStop();
	}

	//!	폜
	virtual void _FilterFactoryDelete()
	{
		delete this;
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	tB^
	CIndexFilter			m_filter;
};
