#include "StdAfx.h"
#include "InterfaceManager.h"

CInterfaceManager::CInterfaceManager(void)
{
}

CInterfaceManager::~CInterfaceManager(void)
{
	Stop();
}

///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CInterfaceManager::Start(CIServerToolWrap serverTool)
{
	ASSERT(!m_init);
	m_init = TRUE;
}

/*!
	~
*/
void CInterfaceManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	NA
	m_ifArray.RemoveAll();
}

/*!
	C^tF[Xo^
*/
int CInterfaceManager::RegisterInterface(CString interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface)
{
	if(ifRegister == NULL)
		return(-1);

	//	o^
	int ret = _RegisterInterface(interfaceName, ifRegister, oldInterface);

	//	KvȂʒm
	if(oldInterface != NULL && *oldInterface != NULL)
		(*oldInterface)->NotifyOverload();

	return(ret);
}

/*!
	C^[tF[Xo^
*/
int CInterfaceManager::UnRegisterInterface(CString interfaceName, IManagerInterfacePtr ifUnRegister, IManagerInterfacePtr oldInterface)
{
	SCOPE_LOCK();

	//	
	int index = FindIndex(interfaceName);
	if(index == -1)
		return(-1);
	if(m_ifArray[index].m_interface != ifUnRegister)
		return(-1);

	//	
	if(oldInterface == NULL)
		m_ifArray.RemoveAt(index);
	else
		m_ifArray[index].m_interface = oldInterface;
	return(0);
}

/*!
	C^tF[X擾
*/
void *CInterfaceManager::GetInterface(CString interfaceName, int ifVersion)
{
	SCOPE_LOCK();

	//	
	int index = FindIndex(interfaceName);
	if(index == -1)
		return(NULL);

	return(m_ifArray[index].m_interface->GetInterface(ifVersion));
}


/////////////////////////////////////////////////////////////////////////////////
//	⏕֐
/////////////////////////////////////////////////////////////////////////////////
/*!
	C^tF[Xo^
*/
int CInterfaceManager::_RegisterInterface(CString interfaceName, IManagerInterfacePtr ifRegister, IManagerInterfacePtr *oldInterface)
{
	SCOPE_LOCK();

	int index = FindIndex(interfaceName);
	if(index != -1)
	{
		//	I[o[[hs\?
		if(oldInterface == NULL)
			return(-1);

		*oldInterface = m_ifArray[index].m_interface;
		m_ifArray[index].m_interface = ifRegister;
	}
	else
	{
		if(oldInterface != NULL)
			*oldInterface = NULL;

		m_ifArray.Add(CRegisterdInterface(interfaceName, ifRegister));
	}
	return(0);
}

/*!
	
*/
int CInterfaceManager::FindIndex(CString ifName)
{
	SCOPE_LOCK();

	for(int i=0;i<m_ifArray.GetSize();i++)
	{
		if(m_ifArray[i].m_interfaceName == ifName)
			return(i);
	}
	return(-1);
}
