#pragma once
#include "iresponse.h"
#include "ConnectionToolWrap.h"
#include "BinaryData.h"


/*!
	X|Xt@Ng x[X
*/
class CResponseFactoryBase :
	public IResponseFactory
{
public:
	virtual ~CResponseFactoryBase(void)
	{
	}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void ResponseFactoryStart(IServerToolPtr serverTool) { _ResponseFactoryStart(serverTool); };

	//!	~
	virtual void ResponseFactoryStop() { _ResponseFactoryStop(); };

	//!	폜
	virtual void ResponseFactoryDelete() {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃ACeH
	virtual int ResponseFactoryIsYourRequest(IWorkspaceAccessPtr context)
	{
		return _ResponseFactoryIsYourRequest(CWorkspaceAccess(context));
	}

	//!	X|X擾
	virtual IResponsePtr ResponseFactoryGetResponse()
	{
		return _ResponseFactoryGetResponse();
	}

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	
	virtual void _ResponseFactoryStart(CIServerToolWrap serverTool) {};

	//!	~
	virtual void _ResponseFactoryStop() {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	擾
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	̃ACeH
	virtual int _ResponseFactoryIsYourRequest(CContext context) = 0;

	//!	X|X擾
	virtual IResponsePtr _ResponseFactoryGetResponse() = 0;
};


/*!
	X|X x[X
*/
class CResponseBase :
	public IResponse
{
public:
	virtual ~CResponseBase(void) {}

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	(OցI)
	virtual void ResponseStart(IConnectionToolPtr responseContext) { _ResponseStart(responseContext); };

	//!	~(OցI)
	virtual void ResponseStop(IConnectionToolPtr responseContext)  { _ResponseStop(responseContext); };

	//!	X|X擾(Kstatic̈ɐ錾Ȃ΂ȂȂ)
	virtual LPCTSTR GetResponseName() = 0;

	//!	폜
	virtual void ResponseDelete() {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_ݒ
	virtual void ResponseSetRequest(IConnectionToolPtr responseContext) { _ResponseSetRequest(responseContext); };

	//!	NGXg{fBݒ(JԂ)
	virtual void ResponseSetRequestBody(IConnectionToolPtr responseContext, IBinaryDataPtr body) { _ResponseSetRequestBody(responseContext, CBinaryData(body)); };

	//!	NGXg
	virtual void ResponseEndRequest(IConnectionToolPtr responseContext) { _ResponseEndRequest(responseContext); };


	//!	X|X
	virtual void ResponseBuildResponse(IConnectionToolPtr responseContext) { _ResponseBuildResponse(responseContext); };


	//!	X|Xwb_擾
	virtual void ResponseGetResponse(IConnectionToolPtr responseContext) { _ResponseGetResponse(responseContext); };

	//!	X|X{fB擾
	virtual int ResponseGetResponseBody(IConnectionToolPtr responseContext, IBinaryDataPtr body, int blockSize) { return _ResponseGetResponseBody(responseContext, CBinaryData(body), blockSize); };

	//!	X|X
	virtual void ResponseEndResponse(IConnectionToolPtr responseContext) { _ResponseEndResponse(responseContext); };

protected:
	//////////////////////////////////////////////////////////////////////////////////////////////
	//	
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	(OցI)
	virtual void _ResponseStart(CIConnectionToolWrap responseContext) {};

	//!	~(OցI)
	virtual void _ResponseStop(CIConnectionToolWrap responseContext)  {};

	//////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X
	//////////////////////////////////////////////////////////////////////////////////////////////
	//!	NGXgwb_ݒ
	virtual void _ResponseSetRequest(CIConnectionToolWrap responseContext) {};

	//!	NGXg{fBݒ(JԂ)
	virtual void _ResponseSetRequestBody(CIConnectionToolWrap responseContext, CBinaryData &body) {};

	//!	NGXg
	virtual void _ResponseEndRequest(CIConnectionToolWrap responseContext) {};


	//!	X|X
	virtual void _ResponseBuildResponse(CIConnectionToolWrap responseContext) {};


	//!	X|Xwb_擾
	virtual void _ResponseGetResponse(CIConnectionToolWrap responseContext) {};

	//!	X|X{fB擾
	virtual int _ResponseGetResponseBody(CIConnectionToolWrap responseContext, CBinaryData &body, int blockSize) { return 0; };

	//!	X|X
	virtual void _ResponseEndResponse(CIConnectionToolWrap responseContext) {};
};
