#include "StdAfx.h"
#include "ServerTextManager.h"
#include "htmlloader.h"
#include "Dir.h"
#include "resource.h"

CServerTextManager::CServerTextManager(void)
{
}

CServerTextManager::~CServerTextManager(void)
{
	Stop();
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
void CServerTextManager::Start(CIServerToolWrap serverTool)
{
	//	ς݁H
	if(m_init)
		return;
	m_init = TRUE;

	//	Rs[A
	m_serverTool = serverTool;

	//	ݒ擾
	m_setting = m_serverTool.GetManagerSetting(m_setting.GetSettingName());

	//	C^[tF[Xo^
	m_serverTool.RegisterManagerInterface(CIServerTextManagerWrap::GetInterfaceName(), this);
}

/*!
	~
*/
void CServerTextManager::Stop()
{
	//	`FbN
	if(!m_init)
		return;
	m_init = FALSE;

	//	C^[tF[Xo^
	m_serverTool.UnRegisterManagerInterface(CIServerTextManagerWrap::GetInterfaceName(), this);
}


///////////////////////////////////////////////////////////////////////////////////////////////////
//	IServerTextManager
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	T[oHTML[h
*/
void CServerTextManager::LoadServerHtmlFile(IStringPtr html, LPCSTR name)
{
	//	[h
	html->SetString(CHtmlLoader::LoadFromFile(CPathTools::AddBackSlash(m_setting.GetServerHtmlDirectory()) + name));
}

/*!
	T[oHTML[h(\[X)
*/
void CServerTextManager::LoadServerHtmlResource(IStringPtr html, LPCSTR resName)
{
	CHtmlLoader	loader;

	if(resName == HTML_RESOURCE_SERVER_RESPONSE)
		html->SetString(CHtmlLoader::LoadFromResource(IDR_HTML_SERVER_RESPONSE));
	else if(resName == HTML_RESOURCE_DIRECTORY_LIST)
		html->SetString(CHtmlLoader::LoadFromResource(IDR_HTML_DIRECTORY_INDEX));
	else
		html->SetString("");
}


