#pragma once
#include "Workspace.h"
#include "threadskeleton.h"
#include "response.h"
#include "request.h"
#include "alias.h"
#include "bandwidthmgr.h"
#include "ProtocolSocket.h"
#include "AcceptedSocketQueue.h"

class CServer;

class CConnectionException
{
public:
	CConnectionException(CString info,int retry=0) {m_info = info;m_retry = retry;}

	CString	m_info;
	int		m_retry;
};

class CServerFatalException
{
public:
	CServerFatalException(CString info)
	{
		m_info = info;
	}

	CString	m_info;
};

//	X|X̒fȂǁA荞݂mF
class CConnection;
class CConnectionInterrupt
{
public:
	CConnectionInterrupt(CConnection *connection);
	CConnectionInterrupt(CConnectionInterrupt &other);
	
	int IsInterrupt();
	operator int();
	CString GetInterruptInfo();

private:
	CConnection		*m_connection;
	CString			m_interruptInfo;
};

class CConnection : public CThreadSkeleton
{
	friend class CConnectionInterrupt;

public:
	CConnection(CServer *server, CAcceptedSocket newSocket);
	virtual ~CConnection(void);
	CWorkspaceAccess GetDate(int detail=0);			//!<	t擾
	virtual void Break();

protected:
	//	I[o[[h
	void ThreadMain();

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	ڑ
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	Ή\Pbgbp
	CProtocolSocket *CreateProtocolSocket(SOCKET socket, int socketType);

	CWorkspaceAccess NewContext();
	void DeleteContext(CWorkspaceAccess context);
	int OneRequest(CWorkspaceAccess context);
	CString RecvHeader();
	void SendFatalError(CString info);
	CString MakeHeaderString(CWorkspaceAccess responseInfo);

	void WriteLog(CWorkspaceAccess &context);
	void UpdateTransSize(CWorkspaceAccess &context);

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	ׂ`FbN
	void CheckServerOverload(CWorkspaceAccess &context);

	//!	ANZX`FbN
	void CheckAccess(CWorkspaceAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef);

	//!	[U[`FbN
	void CheckUser(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	zXg`FbN
	int CheckKickHost(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	ړ̊mF
	void CheckMove(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	WebDAV
	void WebDAV(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	IndexmF
	void CheckIndex(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	CGI
	void CGI(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	//!	SSI
	void SSI(CWorkspaceAccess &context,CRequest &request,CAlias &alias);

	void SendResponse(CWorkspaceAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef,CResponse *response);
	void RecvData(CWorkspaceAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef,CResponse *response);
	void SendData(CWorkspaceAccess &context,CRequest &request,CAlias &alias,CBandWidthReference &bandRef,CResponse *response,__int64 length);

	int CheckUser(CString userName,CString passwd,CAlias alias);
	void Delay(int tick);
	

protected:
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//	X|X쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//!	^CAEg
	int						m_serverTimeout;

	//!	KeepAlive
	int						m_maxKeepAliveTime;

	//!	KeepAlive
	int						m_keepAlive;

	//!	tp̈
	CWorkspace				m_date;

	__int64					m_sendSize;
	__int64					m_recvSize;
	__int64					m_recvDataSize;;

	CServer					*m_server;
	CConnectionInterrupt	m_interrupt;

	//!	\Pbg
	SOCKET					m_rawSocket;

	//!	\Pbg^Cv
	int						m_rawSocketType;

	//!	\Pbgbp
	CProtocolSocket			*m_protocolSocket;
};

