#include "StdAfx.h"
#include "Listener.h"
#include "TextTools.h"
#include "ServerStartException.h"


CListener::CListener(void)
{
}

CListener::~CListener(void)
{
	StopListener();
}



/////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
void CListener::InitListener(CAcceptedSocketQueue *queue, int socketType, int errorRetryTime)
{
	m_queue = queue;
	m_socketType = socketType;
	m_errorRetryTime = errorRetryTime;
}

/*!
	Jn
*/
void CListener::StartListener()
{
	if(OpenPorts())
		throw CServerStartException(_T("ʐM|[g̃I[vɎs܂A|[gԍmFĂB"));

	if(StartThread())
		throw CServerStartException(_T("Xbh̋NɎs܂B"));
}

/*!
	~
*/
void CListener::StopListener()
{
	//	Xbh~
	EndThread();

	//	|
	CloseAllPorts();
}

/*!
	N[Abv
*/
void CListener::CloseAllPorts()
{
	//	|
	for(int i=0;i<m_listeners.GetSize();i++)
		delete m_listeners[i];
	m_listeners.RemoveAll();
}

/*!
	ݒ肩|[gǉ
*/
void CListener::AddPortsFromSetting(CString strPorts)
{
	//	|[g擾
	CStringArray	ports;
	CTextTools::GetAllToken(strPorts, ports, ",", TRUE);

	//	o^
	for(int i=0;i<ports.GetSize();i++)
	{
		int port = atoi(ports[i]);

		if(port > 0 && port < 65536)
			AddPort(port);
	}
}

/*!
	|[g̒ǉ
*/
void CListener::AddPort(int port)
{
	//	֎~
	if(IsRunning())
		return;

	//	H
	if(m_listeners.GetSize() >= MAXIMUM_WAIT_OBJECTS)
		throw CServerStartException(_T("ʐM|[g̍ől𒴂܂B"));

	//	ǉ
	m_listeners.Add(new CListenSocket(port));
}


/////////////////////////////////////////////////////////////////////////////////////
//	Xbh֐
/////////////////////////////////////////////////////////////////////////////////////
/*!
	Xbh
*/
void CListener::ThreadMain()
{
	//	XbhD
	::SetThreadPriority(::GetCurrentThread(), THREAD_PRIORITY_ABOVE_NORMAL);

	//	G[[v
	while(!GetBreak())
	{
		//	[v
		AcceptLoop();

		//	|[g̑҂󂯂蒼
		while(!GetBreak() && OpenPorts())
			WaitForSomeObjects(m_errorRetryTime, GetBreakEvent());	//	G[Ȃ̂ŁA΂炭ҋ@
	}

	//	
	ClosePorts();
}

/*!
	t[v
*/
int CListener::AcceptLoop()
{
	//	҂󂯃[v
	while(!GetBreak())
	{
		//	݂
		if(AcceptConnections())
			return(-1);		//	G[

		//	Cxg҂
		WaitNextRequest();
	}

	return(0);
}


/*!
	|[gJ
*/
int CListener::OpenPorts()
{
	//	܂́Aׂĕ
	ClosePorts();

	//	SẴ|[gJ
	for(int i=0;i<m_listeners.GetSize();i++)
	{
		//	҂󂯊Jn
		if(m_listeners[i]->StartListen())
			return(-1);
	}

	return(0);
}

/*!
	|[g
*/
void CListener::ClosePorts()
{
	//	SẴ|[g
	for(int i=0;i<m_listeners.GetSize();i++)
	{
		//	҂󂯒~
		m_listeners[i]->EndListen();
	}
}


/*!
	ڑ󂯕t
*/
int CListener::AcceptConnections()
{
	//	e|
	SOCKET		newSock;
	CIPAddress	ip;

	while(1)
	{
		//	SẴ|[g`FbN
		int	acceptedCount = 0;
		for(int i=0;i<m_listeners.GetSize();i++)
		{
			//	t݂
			switch(m_listeners[i]->TryAccept(newSock, ip))
			{
			//	\PbgȂ
			case LISTEN_SOCKET_NOCLIENT:
				break;

			//	G[
			case LISTEN_SOCKET_ERROR:
				return(-1);

			//	VKڑ
			case LISTEN_SOCKET_ACCEPTED:
				acceptedCount++;

				OnNewConnection(newSock);
				break;
			}
		}

		//	ʖ
		if(acceptedCount == 0)
			return(0);
	}
}



/*!
	ڑ̂҂
*/
void CListener::WaitNextRequest()
{
	//	Cxg
	int	eventCount = m_listeners.GetSize();
	if(eventCount > MAXIMUM_WAIT_OBJECTS - 1)
		eventCount = MAXIMUM_WAIT_OBJECTS - 1;

	//	ׂẴCxg擾
	HANDLE	waits[MAXIMUM_WAIT_OBJECTS];
	for(int i=0;i<eventCount;i++)
		waits[i+1] = m_listeners[i]->GetEventHandle();

	//	҂
	waits[0] = GetBreakEvent();
	::WaitForMultipleObjects(eventCount + 1, waits, FALSE, INFINITE);
}


/*!
	VKڑ
*/
void CListener::OnNewConnection(SOCKET socket)
{
	CAcceptedSocket	addSocket(socket, m_socketType);
	if(m_queue->AddNewConnection(addSocket))
		addSocket.Abort();
}

