#pragma once
/*
	PathTools.h

	Version		: 0.0 (Release1)
	Version		: 0.0 (Release1)
			: t@ČpX̏Ȃ


	쐬		: 2000/12/07
	C		: 2009/08/29
	藚	: 
*/

#include <shlobj.h>

/*!
	pX֌W̏sNX
*/
class CPathTools
{
public:
public:
	///////////////////////////////////////////////////////////////////////
	//	pXϊ
	///////////////////////////////////////////////////////////////////////
	//!	hCu̎擾
	static CString PathToDrive(CString path);

	//!	fBNgpX̎擾
	static CString PathToDir(CString path);

	//!	t@C̎擾
	static CString PathToName(CString path);

	//!	t@C̎擾(gqȂ)
	static CString PathToNameNoExt(CString path);

	//!	t@Cgq̎擾
	static CString PathToExt(CString path);

	//!	ЂƂ̃fBNgpX擾
	static CString GetUpDir(CString path);

	//!	gȂu
	static CString SafeName(CString name, CString replace = _T("_"));

	//!	\it@C or tH_ or hCuj擾
	static CString PathToViewName(CString name);

	///////////////////////////////////////////////////////////////////////
	//	pX̔r
	///////////////////////////////////////////////////////////////////////
	//!	pXɊ܂܂Ă邩ׂ
	static int IsInPath(CString parentPath, CString childPath);

	///////////////////////////////////////////////////////////////////////
	//	/\̉H
	///////////////////////////////////////////////////////////////////////
	//!	XbVɒǉ
	static CString AddSlash(CString path);

	//!	obNXbVɒǉ
	static CString AddBackSlash(CString path);

	//!	XbV납폜
	static CString RemoveSlash(CString path);

	//!	obNXbV납폜
	static CString RemoveBackSlash(CString path);

	//!	ŌɃXbV邩
	static int CheckSlash(CString path);
	
	//!	ŌɃobNXbV邩
	static int CheckBackSlash(CString path);
	
	//!	Ō̕`FbN
	static int CheckLastChar(CString path, TCHAR c);

	///////////////////////////////////////////////////////////////////////
	//	W[pX
	///////////////////////////////////////////////////////////////////////
	//!	W[pX擾
	static CString GetAppPath();

	//!	W[pX擾
	static CString GetAppPathName();

	/////////////////////////////////////////////////////////////////////////
	//	epX擾
	/////////////////////////////////////////////////////////////////////////
	//!	pXϐũpX擾
	static CString GetPathSwapString(CString path);

	//!	Windows pX擾
	static CString GetWindowsPath();

	//!	System32 pX擾
	static CString GetSystem32Path();

	//!	Program Files pX擾
	static CString GetProgramFilesPath();

	//!	All Users/Application Data pX擾
	static CString GetCommonAppDataPath();
};


/*!
	
*/
///////////////////////////////////////////////////////////////////////
//	pXϊ
///////////////////////////////////////////////////////////////////////
/*!
	֐		: CPathTools::PathToName(CString path)
	e	: pXt@C擾
			: pX
	Al		: t@C
*/
_inline CString CPathTools::PathToDrive(CString path)
{
	if(path.Mid(1,1) != _T(":"))
		return(_T(""));

	return(path.Left(1) + _T(":")); //	(X:)
}

/*!
	֐		: CPathTools::PathToName(CString path)
	e	: pXt@C擾
			: pX
	Al		: t@C
*/
_inline CString CPathTools::PathToName(CString path)
{
	int	index;

	index = path.ReverseFind(_T('\\'));
	if(index==-1)
		return(path);

	return(path.Right(path.GetLength() - index - 1));
}

/*!
	֐		: CPathTools::PathToNameNoExt(CString path)
	e	: pXt@C(gqȂ)擾
			: pX
	Al		: t@C(gqȂ)
*/
_inline CString CPathTools::PathToNameNoExt(CString path)
{
	CString	name = PathToName(path);
	int index = name.ReverseFind(_T('.'));
	if(index == -1)
		return(name);
	else
		return(name.Left(index));
}

/*!
	֐		: CPathTools::PathToDir(CString path)
	e	: pXt@C폜
			: pX
	Al		: pX
*/
_inline CString CPathTools::PathToDir(CString path)
{
	int	index;

	index = path.ReverseFind(_T('\\'));
	if(index==-1)
		return(_T(""));

	path = path.Left(index);
	path = AddBackSlash(path);

	return(path);
}

/*!
	֐		: CPathTools::PathToDir(CString path)
	e		: pXgq擾
				: pX
	Al		: pX
*/
_inline CString CPathTools::PathToExt(CString path)
{
	int	index;

	index = path.ReverseFind(_T('.'));
	if(index==-1)
		return(path);

	return(path.Right(path.GetLength() - index - 1));
}


/*!
	\it@C or tH_ or hCuj擾
*/
_inline CString CPathTools::PathToViewName(CString path)
{
	//	t@C擾
	CString name = PathToName(path);
	if(!name.IsEmpty())
		return(name);
	
	//	obNXbV폜
	path = RemoveBackSlash(path);

	//	hCuH
	if(CheckLastChar(path, _T(':')))
		return(path + _T("\\"));

	//	fBNg
	return(PathToName(path));
}

/*!
	ЂƂ̃fBNgpX擾
*/
_inline CString CPathTools::GetUpDir(CString path)
{
	path = RemoveBackSlash(path);
	int index = path.ReverseFind(_T('\\'));
	if(index == -1)
		return(path);

	return(AddBackSlash(path.Mid(0,index)));
}


/*!
	gȂu
*/
_inline CString CPathTools::SafeName(CString name, CString replace)
{
	name.Replace(_T("/"),replace);
	name.Replace(_T("\\"),replace);
	name.Replace(_T(":"),replace);
	name.Replace(_T("?"),replace);
	name.Replace(_T("*"),replace);
	name.Replace(_T("\""),replace);
	name.Replace(_T(">"),replace);
	name.Replace(_T("<"),replace);

	return(name);
}

///////////////////////////////////////////////////////////////////////
//	pX̔r
///////////////////////////////////////////////////////////////////////
/*!
	pXɊ܂܂Ă邩ׂ

	\param parentPath	̃pX̃TufBNgׂ
	\param childPath	ׂpX
	\return				TRUE:TufBNg
*/
_inline int CPathTools::IsInPath(CString parentPath, CString childPath)
{
	if(parentPath.CompareNoCase(childPath.Left(parentPath.GetLength())) == 0)
		return(TRUE);

	return(FALSE);
}

///////////////////////////////////////////////////////////////////////
//	/\̉H
///////////////////////////////////////////////////////////////////////
/*!
	XbVɒǉ
*/
_inline CString CPathTools::AddSlash(CString path)
{
	if(CheckSlash(path))
		return(path);

	return(path + _T("/"));
}

/*!
	obNXbVɒǉ
*/
_inline CString CPathTools::AddBackSlash(CString path)
{
	if(CheckSlash(path) || CheckBackSlash(path))
		return(path);

	return(path + _T("\\"));
}

/*!
	XbV납폜
*/
_inline CString CPathTools::RemoveSlash(CString path)
{
	if(CheckSlash(path))
		path = path.Left(path.GetLength()-1);

	return(path);
}

/*!
	obNXbV납폜
*/
_inline CString CPathTools::RemoveBackSlash(CString path)
{
	if(CheckBackSlash(path))
		path = path.Left(path.GetLength()-1);

	return(path);
}

/*!
	Ō̕`FbN
*/
_inline int CPathTools::CheckLastChar(CString path, TCHAR c)
{
	LPCTSTR	ptr = path;

	//	󕶎
	if(*ptr == 0)
		return(0);

#ifdef _UNICODE
	while(1)
	{
		//	I?
		if(*(ptr+1) == 0)
		{
			if(*ptr == c)
				return(1);
			else
				return(0);
		}

		ptr++;
	}
#else
	while(1)
	{
		//	VOoCg
		if(*ptr <= 0x80 || (*ptr >= 0xA0 && *ptr <= 0xDF))
		{
			//	I?
			if(*(ptr+1) == 0)
			{
				if(*ptr == c)
					return(1);
				else
					return(0);
			}
			ptr++;
		}
		else
		{
			//	I?
			if(*(ptr+1) == 0 || *(ptr+2) == 0)
				return(0);
			ptr+=2;
		}
	}
#endif
}

/*!
	ŌɃXbV邩
*/
_inline int CPathTools::CheckSlash(CString path)
{
	return(CheckLastChar(path,_T('/')));
}

/*!
	ŌɃobNXbV邩
*/
_inline int CPathTools::CheckBackSlash(CString path)
{
	return(CheckLastChar(path,_T('\\')));
}

///////////////////////////////////////////////////////////////////////
//	W[pX
///////////////////////////////////////////////////////////////////////
/*!
	W[pX擾
*/
_inline CString CPathTools::GetAppPath()
{
	TCHAR	s[MAX_PATH+1];
	DWORD len = GetModuleFileName(NULL, s, MAX_PATH);

	while (s[len--]!=_T('\\') && len!=0 )
		;
	s[len+2] = _T('\0');        // }[NŏI点

	return(s);
}

/*!
	W[pX擾
*/
_inline CString CPathTools::GetAppPathName()
{
	TCHAR	s[MAX_PATH+1];
	GetModuleFileName(NULL, s, MAX_PATH);

	return(s);
}



/////////////////////////////////////////////////////////////////////////
//	epX擾
/////////////////////////////////////////////////////////////////////////
/*!
	pXϐũpX擾

	%WINDOWS%		c:\Windows
	%SYSTEM32%		c:\Windows\System32
	%PROGRAMFILES%	c:\Program Files
*/
_inline CString CPathTools::GetPathSwapString(CString path)
{
	//	TCY擾
	int len = ExpandEnvironmentStrings(path, NULL, 0) + 1;

	//	ϊ
	CString	ret;
	ExpandEnvironmentStrings(path, ret.GetBuffer(len + 1), len);
	ret.ReleaseBuffer();

	return(ret);
}

/*!
	Windows pX擾
*/
_inline CString CPathTools::GetWindowsPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_WINDOWS, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}

/*!
	System32 pX擾
*/
_inline CString CPathTools::GetSystem32Path()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_SYSTEM, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}

/*!
	Program Files pX擾
*/
_inline CString CPathTools::GetProgramFilesPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_PROGRAM_FILES, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}


/*!
	All Users/Application Data pX擾
*/
_inline CString CPathTools::GetCommonAppDataPath()
{
	TCHAR szPath[_MAX_PATH];

	SHGetSpecialFolderPath(NULL, szPath, CSIDL_COMMON_APPDATA, FALSE);

	return(CPathTools::AddBackSlash(szPath));
}

