#pragma once
#include "normalresponse.h"

class CDirectoryResponse :
	public CNormalResponse
{
public:
	CDirectoryResponse(CServer *server,CWorkspaceAccess context,CRequest request,CAlias alias);
	virtual ~CDirectoryResponse(void);

	virtual void PreCreateResponse() {};				//	1:X|X		
	virtual void SetNextData(CBuffer &data) {};		//	2:Mf[^̐ݒ(JԂ)
	virtual void CreateResponse();					//	3:X|X̐
	virtual __int64 GetResponseSize();				//	4:X|XTCY̎擾
//	virtual CWorkspaceAccess GetResponseInfo();		//	5:X|X擾
	virtual int GetNextData(CBuffer &data);			//	6:X|X̎擾

protected:
	class CFileItem
	{
	public:
		int			m_sortMode;
		CString		m_name;
		CTime		m_lastUpdate;
		__int64		m_size;

		CFileItem() {m_sortMode = 0;};
		int operator > (CFileItem &other)
		{
			switch(m_sortMode)
			{
			case 1:
				return m_lastUpdate > other.m_lastUpdate;
			case 2:
				return m_size > other.m_size;
			default:
				return m_name > other.m_name;
			}
		};
	};

	typedef CSortArray<CFileItem,CFileItem&>	CFileItemArray;

private:
	CHtmlLoader		m_body;
	int				m_done;

	int GetLinkList(CFileItemArray & list, int sortMode=-1);		//	NXg̎擾
	int GetDirectoryList(CFileItemArray & list, int sortMode=-1);	//	fBNgXg̎擾
	int GetFileList(CFileItemArray & list, int sortMode=-1);		//	t@CXg̎擾
	CTime GetTargetDate();											//	fBNg̍쐬Ԃ̎擾
};
