#include "StdAfx.h"
#include "htmlloader.h"
#include "WorkspaceUtility.h"
#include "BinaryData.h"

CHtmlLoader::CHtmlLoader(void)
{
}

CHtmlLoader::~CHtmlLoader(void)
{
}

/*!
 *	\[X烍[h
 *
 *	@param	id	ID
 *	@return		0:
 */
int CHtmlLoader::LoadFromResource(int id)
{
	//	\[X烍[h
	HRSRC res = FindResource(NULL,MAKEINTRESOURCE(id),RT_HTML);
	int	size = SizeofResource(NULL,res);
	HGLOBAL data = LoadResource(NULL,res);


	if(data!=NULL)
	{
		char * buf = m_html.GetBuffer(size + 1);
		memcpy(buf,data,size);
		buf[size] = 0;
		m_html.ReleaseBuffer();
		return(0);
	}
	return(-1);
}


/*!
 *	t@C烍[h
 *
 *	@param	path	pX
 *	@return			0:
 */
int CHtmlLoader::LoadFromFile(CString path)
{
	CBinaryData	load;
	
	//	ǂ
	if(load.LoadFromFile(path))
		return(-1);

	//	Text
	m_html = load.GetString();
	return(0);
}


/*!
 *	us
 *
 *	@param	config	̈
 */
void CHtmlLoader::SwapKey(CWorkspaceAccess config)
{
	CWorkspaceTextSwap	swap;

	//	^OEĂ
	swap.AddSwap("<","&lt;");
	swap.AddSwap(">","&gt;");

	m_html = config.GetKeySwapString(m_html,"",&swap);
}


/*!
 *	us
 *
 *	@param	key		L[
 *	@param	data	f[^
 */
void CHtmlLoader::SwapKey(CString key,CString data)
{
	int index = m_html.Find("%" + key + "%");

	while(index != -1)
	{
		m_html = m_html.Mid(0,index) + data + m_html.Mid(index + 2 + key.GetLength());
		index = m_html.Find("%" + key + "%");
	}
}
