#include "StdAfx.h"
#include "response.h"

CResponse::CResponse(CServer *server,CWorkspaceAccess context)
{
	m_server = server;
	m_context = context;

	m_setting = m_server->m_settingRoot.GetAccess("Setting");
	m_serverInfo = m_server->m_serverInfo;

	//	NGXg̈
	m_requestInfo = context.GetAccess("RequestInfo");
	m_requestOptions = m_requestInfo.GetAccess("Options");

	//	X|Ẍ
	m_responseInfo = m_context.GetAccess("ResponseInfo");
	m_responseOptions = m_responseInfo.GetAccess("Options");

	SetupDefaultResponse();
}

CResponse::~CResponse(void)
{
}

/*!
	X|X擾
*/
CWorkspaceAccess CResponse::GetResponseInfo()
{
	return(m_responseInfo);
}

/*!
	Œ̃X|Xݒ肷
*/
void CResponse::SetupDefaultResponse()
{
	//	X|XR[h
	SetResponseCode(200);

	//	IvV
	m_responseOptions.SetConfig("Server",m_serverInfo.GetConfig("ServerSignature","04WebServer"));	//	T[o
	m_responseOptions.SetConfig("Date",m_context.GetConfig("StartTime::GMT",""));					//	
	m_responseOptions.SetConfig("Content-Type","text/html");										//	^Cv


	//	KeepAlive?
	if(m_setting.GetConfig("Basic::EnableKeepAlive",0) == 0 || m_requestOptions.GetConfig("Connection","").CompareNoCase("keep-alive") != 0)
	{
		m_responseOptions.SetConfig("Connection","Close");											//	ڑ`
	}
	else
	{
		CWorkspaceAccess basic = m_setting.GetAccess("Basic");
		CString	str;
		str.Format("timeout=%d, max=%d",basic.GetConfig("KeepAliveTime",20),basic.GetConfig("MaxKeepAlive",5));
		m_responseOptions.SetConfig("Keep-Alive",str);
		m_responseOptions.SetConfig("Connection","Keep-Alive");
	}
}

/*!
 *	HTTPX|XR[h̐ݒ
 *
 */
void CResponse::SetResponseCode(int code)
{
	//	X|XR[h
	m_responseInfo.SetConfig("ResponseCode",code);
	m_responseInfo.SetConfig("ResponseText",GetHTTPResponseString(code));
}

/*!
 *	HTTPX|XR[h̏ڍׂ𓾂
 *
 */
CString CResponse::GetHTTPResponseString(int code)
{
	switch(code)
	{
		//	
		case	100:
			return("100 Continue");
		case	101:
			return("101 Switching Protocols");
		case	200:
			return("200 OK");
		case	201:
			return("201 Created");
		case	202:
			return("202 Accepted");
		case	203:
			return("203 Non-Authoritative Information");
		case	204:
			return("204 No Content");
		case	205:
			return("205 Reset Content");
		case	206:
			return("206 Partial Content");
		case	207:
			return("207 Multi-Status");

		//	G[i30x͎ɏj
		case	300:
			return("300 Multiple Choices");
		case	301:
			return("301 Moved Permanently");
		case	302:
			return("302 Found");
		case	303:
			return("303 See Other");
		case	304:
			return("304 Not Modified");
		case	305:
			return("305 Use Proxy");
		case	306:
			return("306 (Unused)");
		case	307:
			return("307 Temporary Redirect");
		case	400:
			return("400 Bad Request");
		case	401:
			return("401 Unauthorized");
		case	402:
			return("402 Payment Required");
		case	403:
			return("403 Forbidden");
		case	404:
			return("404 Not Found");
		case	405:
			return("405 Method Not Allowed");
		case	406:
			return("406 Not Acceptable");
		case	407:
			return("407 Proxy Authentication Required");
		case	408:
			return("408 Request Timeout");
		case	409:
			return("409 Conflict");
		case	410:
			return("410 Gone");
		case	411:
			return("411 Length Required");
		case	412:
			return("412 Precondition Failed");
		case	413:
			return("413 Request Entity Too Large");
		case	414:
			return("414 Request-URI Too Long");
		case	415:
			return("415 Unsupported Media Type");
		case	416:
			return("416 Requested Range Not Satisfiable");
		case	500:
			return("500 Internal Server Error");
		case	501:
			return("501 Not Implemented");
		case	502:
			return("502 Bad Gateway");
		case	503:
			return("503 Service Unavailable");
		case	504:
			return("504 Gateway Timeout");
		case	505:
			return("505 HTTP Version Not Supported");
	}

	CString	unknown;

	unknown.Format("%d UNKNOWN",code);
	return(unknown);
}
