#pragma once
#include "normalresponse.h"
#include "connection.h"
#include "ssiparser.h"
#include "subprocess.h"

class CSSIResponse :
	public CNormalResponse
{
public:
	CSSIResponse(CServer *server,CWorkspaceAccess context,CRequest request,CAlias alias,CConnectionInterrupt interrupt);
	~CSSIResponse(void);

	virtual void PreCreateResponse() {};			//	1:X|X		
	virtual void SetNextData(CBuffer &data) {};		//	2:Mf[^̐ݒ(JԂ)
	virtual void CreateResponse();					//	3:X|X̐
	virtual __int64 GetResponseSize();				//	4:X|XTCY̎擾
//	virtual CWorkspaceAccess GetResponseInfo();		//	5:X|X擾
	virtual int GetNextData(CBuffer &data);			//	6:X|X̎擾

protected:
	CSSIParser				m_parser;
	CConnectionInterrupt	m_interrupt;
	CString					m_body;
	int						m_done;
	int						m_prevIf;


	CString					m_currentTimeFormat;
	CString					m_currentSizeFormat;
	
	int DoConfig(CSSIParserItem &item);
	int DoFile(CSSIParserItem &item);
	int DoEcho(CSSIParserItem &item);
	int DoIf(CSSIParserItem &item);
	int DoExec(CSSIParserItem &item);

	void GetEnvironment(CWorkspaceAccess envAccess);
	CString RemoveCGIHeader(CString text);

	CString NameToLocalPath(CString name);
	CString ServerPathToLocalPath(CString path);
};
