#pragma once

#include ".\workspacenode.h"

/*!
	u
*/
class IWorkspaceAutoSwap
{
public:
	//!	ʏ̎擾
	virtual CString SwapString(CString orgKey, CString orgData) = 0;

	//!	폜
	virtual void Delete() {};
};
//!	|C^^
typedef IWorkspaceAutoSwap* IWorkspaceAutoSwapPtr;


class CWorkspace;
class CWorkspaceAccess
{
public:
	CWorkspaceAccess(void);
	CWorkspaceAccess(CWorkspace *root,CString path);
	virtual ~CWorkspaceAccess(void);


	/*********************************************************
		Ȃ
	**********************************************************/
	//!	Sf[^NA
	virtual void Clear(void);

	//!	(㏑Rs[ATum[hƃL[Rs[邪Ãm[h͕ύXȂ)
	virtual void Copy(CWorkspaceAccess &src);

	//!	ANZXNX擾
	virtual CWorkspaceAccess GetAccess(CString subPath);

	//!	[g擾
	CWorkspace * GetRoot();

	//!	O擾
	virtual CString GetNodeName();


	/*********************************************************
		KeyɊւ鏈
	**********************************************************/
	//!	f[^̐ݒ
	virtual void SetKeyStr(CString key, CString data,int noCase=FALSE);
	virtual void SetKeyInt(CString key, int data,int noCase=FALSE);
	virtual void SetKeyInt64(CString key, __int64 data,int noCase=FALSE);
	virtual void SetKeyDWORD(CString key, DWORD data,int noCase=FALSE);

	//!	f[^̎擾
	virtual CString GetKeyStr(CString key, CString defaultData,int noCase=FALSE);
	virtual int GetKeyInt(CString key, int defaultData,int noCase=FALSE);
	virtual __int64 GetKeyInt64(CString key, __int64 defaultData,int noCase=FALSE);
	virtual DWORD GetKeyDWORD(CString key, DWORD defaultData,int noCase=FALSE);

	//!	L[݂̑mF
	virtual int KeyIsExist(CString key,int noCase=FALSE);

	//!	f[^̍폜
	virtual void DeleteKey(CString key,int noCase=FALSE);

	//!	L[擾
	virtual int GetKeyCount();

	//!	SẴL[𕶎ƂĎ擾
	virtual int GetAllKey(CStringArray &list);

	//!	SẴL[Rs[
	virtual void CopyAllKeys(CKeyDataArray &keyData);

	//!	񒆂̃L[f[^ɒu擾
	virtual CString GetKeySwapString(CString str,CString noData=_T(""), IWorkspaceAutoSwapPtr tempSwap = NULL);

	/******************************************************
		GCAX(CConfigNX݊p)
	*******************************************************/
	void SetConfig(CString key, CString data)	{ SetKeyStr(key, data); };								//	f[^̐ݒ
	void SetConfig(CString key, int data)		{ SetKeyInt(key, data); };								//	f[^̐ݒ
	void SetConfig(CString key, UINT data)		{ SetKeyDWORD(key, data); };							//	f[^̐ݒ
	void SetConfig(CString key, __int64 data)	{ SetKeyInt64(key, data); };							//	f[^̐ݒ

	CString GetConfig(CString key, CString defaultData,int noCase=FALSE)	{ return GetKeyStr(key, defaultData, noCase); };	//	f[^̎擾
	int GetConfig(CString key, int defaultData,int noCase=FALSE)			{ return GetKeyInt(key, defaultData, noCase); };	//	f[^̎擾
	UINT GetConfig(CString key, UINT defaultData,int noCase=FALSE)			{ return GetKeyDWORD(key, defaultData, noCase); };	//	f[^̎擾
	__int64 GetConfig(CString key, __int64 defaultData,int noCase=FALSE)	{ return GetKeyInt64(key, defaultData, noCase); };	//	f[^̎擾

	/******************************************************
		Tum[hɊւ鏈
	*******************************************************/
	//!	m[h폜
	virtual void DeleteNode(CString name);

	//!	Tum[h𓾂
	virtual int GetSubNodeCount();

	//!	SẴTum[h𕶎ƂĎ擾
	virtual int GetAllSubNode(CStringArray &list);

protected:
	CString			m_path;
	CWorkspace		*m_root;
};


/*
	Œ`̃[NXy[X`p
*/
//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_STR(PropertyName, PropertyPath, DefaultVal) \
	CString Get##PropertyName(CString defVal = DefaultVal)	{ return GetKeyStr(PropertyPath, defVal); }; \
	void Set##PropertyName(CString val)	{ SetKeyStr(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_INT(PropertyName, PropertyPath, DefaultVal)	\
	int Get##PropertyName(int defVal = DefaultVal)	{ return GetKeyInt(PropertyPath, defVal); }; \
	void Set##PropertyName(int val)	{ SetKeyInt(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_INT64(PropertyName, PropertyPath, DefaultVal)	\
	__int64 Get##PropertyName(__int64 defVal = DefaultVal)	{ return GetKeyInt64(PropertyPath, defVal); }; \
	void Set##PropertyName(__int64 val)	{ SetKeyInt64(PropertyPath, val); };	\
	void Clear##PropertyName()	{ SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_WORKSPACE(PropertyName, PropertyPath)	\
	int Get##PropertyName()	{ return GetAccess(PropertyPath); };


//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_STR(Access, PropertyName, PropertyPath, DefaultVal) \
	CString Get##PropertyName(CString defVal = DefaultVal)	{ return Access.GetKeyStr(PropertyPath, defVal); }; \
	void Set##PropertyName(CString val)	{ Access.SetKeyStr(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_INT(Access, PropertyName, PropertyPath, DefaultVal)	\
	int Get##PropertyName(int defVal = DefaultVal)	{ return Access.GetKeyInt(PropertyPath, defVal); }; \
	void Set##PropertyName(int val)	{ Access.SetKeyInt(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_INT64(Access, PropertyName, PropertyPath, DefaultVal)	\
	__int64 Get##PropertyName(__int64 defVal = DefaultVal)	{ return Access.GetKeyInt64(PropertyPath, defVal); }; \
	void Set##PropertyName(__int64 val)	{ Access.SetKeyInt64(PropertyPath, val); };	\
	void Clear##PropertyName()	{ Access.SetKeyStr(PropertyPath, ""); };	\
	int PropertyName##IsSet() { return !Access.GetKeyStr(PropertyPath, "").IsEmpty(); };

//!	ANZX\bh
#define	DEFINE_PROPERTY_METHOD_ACC_WORKSPACE(PropertyName, PropertyPath)	\
	int Get##PropertyName()	{ return Access.GetAccess(PropertyPath); };


//!	RXgN^܂Ƃ߂Ē`
#define	DEFINE_COMMON_CONSTRUCTOR(className)	\
	className(void) {};\
	className(CWorkspaceAccess  &other)							{ CWorkspaceAccess::operator=(other); };\
	void operator = (CWorkspaceAccess &other)					{ CWorkspaceAccess::operator=(other); };

