#pragma once
#include "BinaryData.h"

class CBase64  
{
public:
	//////////////////////////////////////////////////////////////////////
	// BinaryData <-> Hex
	//////////////////////////////////////////////////////////////////////
	//!	GR[h(Bin->Hex)
	static void EncodeHEXbin(CBinaryData &src, CString &dest);

	//!	fR[h(Hex->Bin)
	static int DecodeHEXbin(CString src, CBinaryData &dest);

	//////////////////////////////////////////////////////////////////////
	// BinaryData <-> B64
	//////////////////////////////////////////////////////////////////////
	//!	GR[h(Bin->B64)
	static void Encode64bin(CBinaryData &src, CString &dest);

	//!	fR[h(B64->Bin)
	static void Decode64bin(CString src, CBinaryData &dest);

	//////////////////////////////////////////////////////////////////////
	// String <-> B64
	//////////////////////////////////////////////////////////////////////
	//!	GR[hiText->B64j
	static CString Encode64(CString string);

	//!	fR[hiB64->Textj
	static CString Decode64(CString b64str);

private:
	//!	16iɕϊ(1ϊj
	static TCHAR GetHexChar(int val);

	//!	16i𐔎(1ϊ)
	static int GetHexVal(TCHAR hex);

	static int GetEncodedLength(int len);
	static int _Encode(char *encoded,const unsigned char *string, int len);
	static int GetDecodedLength(const char *bufcoded);
	static int _Decode(unsigned char *bufplain,const char *bufcoded);
};

