#pragma once
#include "SyncObject.h"
#include <winsvc.h>
#include "ThreadSkeleton.h"

class CSystemService : public CThreadSkeleton
{
public:
	CSystemService(void);
	virtual ~CSystemService(void);

	int RunService();

private:
	virtual void ThreadMain();
	void WINAPI ServiceMain();
	DWORD HandlerEx(DWORD dwControl,DWORD dwEventType,PVOID pvEventData,PVOID pvContext);
	void SetServiceStatus(DWORD dwCurrentStat,DWORD error=0,DWORD dwCheckPoint=0,DWORD dwWaitHint=0);

	SERVICE_STATUS_HANDLE	m_serviceHandle;
	CLockObject<int>		m_wantStop;

private:
	static void WINAPI _ServiceMain(DWORD dwArgc,PSTR *pszArgv);
	static DWORD WINAPI _HandlerEx(DWORD dwControl,DWORD dwEventType,PVOID pvEventData,PVOID pvContext);

public:
	static int AddToService();												//!<	T[rX̒ǉ
	static int DelFromService();											//!<	T[rX̍폜
	static void WriteSystemLog(int event,CString info="",int isError = 0);	//!<	CxgO

};
