#include "StdAfx.h"
#include "ListenSocket.h"

CListenSocket::CListenSocket(int port)
{
	m_port = port;
	m_listenSocket = INVALID_SOCKET;
	m_listenEvent.Create(FALSE, FALSE);
}

CListenSocket::~CListenSocket(void)
{
	EndListen();
}


///////////////////////////////////////////////////////////////////////////
//	
///////////////////////////////////////////////////////////////////////////
/*!
	|[gԍ̐ݒ
*/
void CListenSocket::SetPort(int port)
{
	m_port = port;
}

/*!
	҂󂯂Jn
*/
int CListenSocket::StartListen()
{
	//	ς݁H
	EndListen();

	//	\Pbg
	m_listenSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if(m_listenSocket == INVALID_SOCKET)
		return(-1);

	//	CxgNA
	::ResetEvent(m_listenEvent);

	//	\PbgubLO[h
	if(::WSAEventSelect(m_listenSocket, m_listenEvent, FD_ACCEPT | FD_CLOSE))
		return(-1);

	//	|[g蓖
	if(Bind(m_port))
		return(-1);

	//	ts
	if(listen(m_listenSocket, 5) != 0)
		return(-1);

	return(0);
}

/*!
	҂󂯂I
*/
void CListenSocket::EndListen()
{
	if(m_listenSocket != INVALID_SOCKET)
	{
		closesocket(m_listenSocket);
		m_listenSocket = INVALID_SOCKET;
	}
}

/*!
	tĂ݂

	\return LISTEN_SOCKET_NOCLIENT:ڑȂALISTEN_SOCKET_ERROR:G[ALISTEN_SOCKET_ACCEPTED:ڑ
*/
int CListenSocket::TryAccept(SOCKET &socket, CIPAddress &ip)
{
	//	AhXobt@
	sockaddr_in	addr;
	memset(&addr, 0, sizeof(sockaddr_in));
	int	nSockAddrLen = sizeof(sockaddr_in);

	//	󂯕tĂ݂
	socket = ::WSAAccept(m_listenSocket, (SOCKADDR*)&addr, &nSockAddrLen, NULL, NULL);

	//	H
	if(socket != INVALID_SOCKET)
	{
		ip = addr.sin_addr;
		return(LISTEN_SOCKET_ACCEPTED);
	}

	//	ȂH
	int errorCode = WSAGetLastError();
	if(errorCode == WSAEWOULDBLOCK || errorCode == WSAECONNRESET)
		return(LISTEN_SOCKET_NOCLIENT);

	//	G[
	return(LISTEN_SOCKET_ERROR);
}


///////////////////////////////////////////////////////////////////////////
//	c[
///////////////////////////////////////////////////////////////////////////
/*!
	|[g蓖
*/
int CListenSocket::Bind(int bindPort)
{
	SOCKADDR_IN	sockAddr;

	memset(&sockAddr, 0, sizeof(sockAddr));
	sockAddr.sin_family			= AF_INET;
	sockAddr.sin_addr.s_addr	= htonl(INADDR_ANY);
	sockAddr.sin_port			= htons((u_short)bindPort);

	if(bind(m_listenSocket, (SOCKADDR*)&sockAddr, sizeof(sockAddr)) != 0)
		return(-1);
	return(0);
}