#include "StdAfx.h"
#include ".\workspacelistaccess.h"

CWorkspaceListAccess::CWorkspaceListAccess(CString listName)
{
	m_listName = listName;
}

CWorkspaceListAccess::~CWorkspaceListAccess(void)
{
}

CWorkspaceListAccess::CWorkspaceListAccess(CWorkspaceAccess &other, CString listName)
{
	m_listName = listName;
	CWorkspaceAccess::operator=(other.GetAccess(listName));
}

//////////////////////////////////////////////////////////////////////////////
//	擾
//////////////////////////////////////////////////////////////////////////////
/*!
	̎擾
*/
int CWorkspaceListAccess::GetItemCount()
{
	return(GetSubNodeCount());
}


/*!
	ACe̎擾
*/
CWorkspaceAccess CWorkspaceListAccess::GetItem(int index)
{
	//	SẴTum[h擾
	CStringArray	list;
	GetAllSubNode(list);

	//	S`FbN
	ASSERT(index >= 0 && index < list.GetCount());

	//	Ώۂ擾
	return(GetAccess(list[index]));
}


/*!
	ACeǉ
*/
CWorkspaceAccess CWorkspaceListAccess::GetNewItem()
{
	int itemNo = 0;
	CString	name;

	//	dȂĂȂOT
	CStringArray	list;
	GetAllSubNode(list);
	while(1)
	{
		//	Ȃ
		int loopFlag = 0;
		name.Format("%s_%04d", m_listName, itemNo);
		for(int i=0; i<list.GetSize(); i++)
		{
			if(name.CompareNoCase(list[i]) == 0)
				loopFlag = 1;
		}

		//	Ȃ
		if(loopFlag == 0)
			break;

		//	
		itemNo ++;
	}
	
	return(GetAccess(name));
}


/*!
	ACe̍폜
*/
void CWorkspaceListAccess::DeleteItem(CWorkspaceAccess item)
{
	DeleteNode(item.GetNodeName());
}


/*!
	ACe̍폜
*/
void CWorkspaceListAccess::DeleteItem(int index)
{
	DeleteNode(GetItem(index).GetNodeName());
}

//////////////////////////////////////////////////////////////////////////////
//	\[g
//////////////////////////////////////////////////////////////////////////////
/*!
	\[g
*/
void CWorkspaceListAccess::Sort(CWorkspaceListAccessSortBase *sortBase)
{
	int					Max = (int)GetItemCount();
	CWorkspaceAccess	keyitem = GetNewItem();

	for(int i=1;i<Max;i++)
	{
		keyitem.Copy(GetItem(i));

		int	j;
		for(j=i-1;j>=0;j--)
		{
			if(sortBase->IsBefore(GetItem(j), keyitem))
			{
				GetItem(j+1).Copy(GetItem(j));
			}
			else
			{
				break;
			}
		}

		GetItem(j+1).Copy(keyitem);
	}

	DeleteItem(keyitem);
}


/*!
	\[g(L[e)
*/
void CWorkspaceListAccess::Sort(CString key1, CString key2, CString key3)
{
	CWorkspaceListAccessSimpleSort	sort;
	sort.m_keyName.Add(key1);
	if(!key2.IsEmpty())
		sort.m_keyName.Add(key2);
	if(!key3.IsEmpty())
		sort.m_keyName.Add(key3);

	Sort(&sort);
}


//////////////////////////////////////////////////////////////////////////////
//	CWorkspaceListAccessSimpleSort
//////////////////////////////////////////////////////////////////////////////
/*!
	r
*/
int CWorkspaceListAccessSimpleSort::IsBefore(CWorkspaceAccess from, CWorkspaceAccess to)
{
	ASSERT(m_keyName.GetCount() > 0);

	for(int i=0;i<m_keyName.GetCount();i++)
	{
		if(from.GetKeyStr(m_keyName[i], "") != to.GetKeyStr(m_keyName[i], ""))
			return(from.GetKeyStr(m_keyName[i], "") > to.GetKeyStr(m_keyName[i], ""));
	}

	return(TRUE);
}

