<#list tableList as table>


CREATE TABLE ${table.tableName} (
	<#assign primarys=table.primaryKey>
	<#assign primaryField=primarys?first>
	<#assign primaryName=primaryField.field.fieldName?uncap_first>
	<#assign identity="">
	<#list table.tableField as tableField>
		<#assign fieldName=tableField.fieldName?uncap_first>
		<#assign fieldDataType=tableField.dataType>
		<#assign rdbDataType=fieldDataType.rdbTypeName>
		<#assign IsNotNull=fieldDataType.isNotNullString>
		<#assign colmnSize="("+fieldDataType.colmnSize+")">
		<#assign colmnSizePoint="("+fieldDataType.colmnSize+"."+fieldDataType.pointNumber+")">
		<#if colmnSize == "(0)">
			<#assign colmnSize = "">
		<#else>
			<#assign colmnSizePoint = "">
		</#if>
		<#if colmnSizePoint == "(0.0)">
			<#assign colmnSizePoint = "">
		</#if>
		<#if fieldName == primaryName>
       ${fieldName}           ${rdbDataType}${colmnSize}${colmnSizePoint} ${IsNotNull} generated by default
				AS IDENTITY( 
					START WITH 1,
					INCREMENT BY 1),
		<#else>
       ${fieldName}              ${rdbDataType}${colmnSize}${colmnSizePoint} ${IsNotNull} ,
        </#if>
	</#list>
       PRIMARY KEY (${primaryName})
);

	<#list table.parentTable as linkTable>
		<#assign fkName=linkTable.childFieldName>
CREATE INDEX XIF${linkTable_index}${table.tableName} ON ${table.tableName}
(
       ${fkName}                        ASC
);
	</#list>

--CREATE SEQUENCE ${primaryName}
-- START WITH 1
-- INCREMENT BY 1
--;

</#list>

