/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.ant;

import java.io.File;

import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.OutputCode;
import org.seasar.codegen.impl.NomalDtoOutputCodeImpl;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

public class EachGen {
    private String diconPath;

    private File destinationDir;

    private File csvFile;

    private String packageName;

    private String templateDir;

    public void generate() {
        S2Container s2 = S2ContainerFactory.create(this.diconPath);
        s2.init();

        try {
            ImportCodeData icd = (ImportCodeData) s2
                    .getComponent(ImportCodeData.class);
            // OutputCode oc = (OutputCode) s2.getComponent(OutputCode.class);
            NomalDtoOutputCodeImpl oc = (NomalDtoOutputCodeImpl) s2
                    .getComponent(OutputCode.class);
            oc.setPackageName(this.packageName);
            oc.setTemplateDir(this.templateDir);
            oc
                    .generateCode(this.destinationDir, icd
                            .readCodeData(this.csvFile));
        } finally {
            s2.destroy();
        }
    }

    public void setCsvFile(File csvFile) {
        this.csvFile = csvFile;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public void setDiconPath(String diconPath) {
        this.diconPath = diconPath;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }
}