/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.element;

import org.seasar.codegen.util.ToStringUtil;

public class LinkTable {
    private String tableName;

    private String parentFieldName;

    private String childFieldName;

    private String tableNameForDto;

    private String parentFieldNameForDto;

    private String childFieldNameForDto;;

    public String getChildFieldName() {
        return childFieldName;
    }

    public void setChildFieldName(String childFieldName) {
        this.childFieldName = childFieldName;
    }

    public String getParentFieldName() {
        return parentFieldName;
    }

    public void setParentFieldName(String parentFieldName) {
        this.parentFieldName = parentFieldName;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableNameForDto() {
        if (tableNameForDto == null) {
            return tableName;
        }
        return tableNameForDto;
    }

    public void setTableNameForDto(String tableNameForDto) {
        this.tableNameForDto = tableNameForDto;
    }

    public String getChildFieldNameForDto() {
        if (childFieldNameForDto == null) {
            return childFieldName;
        }
        return childFieldNameForDto;
    }

    public void setChileFieldNameForDto(String chileFieldNameForDto) {
        this.childFieldNameForDto = chileFieldNameForDto;
    }

    public String getParentFieldNameForDto() {
        if (parentFieldNameForDto == null) {
            return parentFieldName;
        }
        return parentFieldNameForDto;
    }

    public void setParentFieldNameForDto(String parentFieldNameForDto) {
        this.parentFieldNameForDto = parentFieldNameForDto;
    }

    public String toString() {
        return ToStringUtil.toString(this);
    }

}
