/*
 * Copyright 2006-2007 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
/**
 * 
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.util.Map;

import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.util.FileUtil;
import org.seasar.framework.log.Logger;

/**
 * @author azusa
 * 
 */
public class DDLOutputCodeImpl extends NomalDiconOutputCodeImpl {

    private Logger log = Logger.getLogger(DDLOutputCodeImpl.class);

    protected Dbms dbms;

    @Override
    public void generateCode(File baseDir, Map tableList) {
        super.setPackageName("");
        String templateFileName = getTemplateFileName() + "_"
                + dbms.getSuffix() + ".ftl";
        File dest = new File(getTemplateDir() + FileUtil.getSeparator()
                + templateFileName);
        if (!dest.exists()) {
            log.log("WCDG0003", new String[] { dest.getPath() });
            return;
        }
        super.setTemplateFileName(templateFileName);
        super.generateCode(baseDir, tableList);
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }
}
