package jp.co.epson.watch.plaWasabi.action.stx;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;

import jp.co.epson.watch.plaWasabi.commons.Constants;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Action;
import jp.co.epson.watch.plaWasabi.dto.formConfig.FormConfig;
import jp.co.epson.watch.plaWasabi.form.stx.SaveForm;
import jp.co.epson.watch.plaWasabi.service.form.FormService;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.seasar.framework.container.annotation.tiger.InitMethod;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;
import org.xml.sax.SAXException;

public class AdjustAction {

  @ActionForm
  @Resource
  private SaveForm saveForm;

  @Resource
  private HttpSession session;

  @Resource
  private HttpServletRequest request;

  private FormConfig config;

  @Resource
  private FormService formService;

  @InitMethod
  public void init() {
    String formId = this.request.getParameter(Constants.FORM_ID);
    if (StringUtils.isNotBlank(formId)) {
      this.config = this.formService.loadFormConfig(formId);
    }
  }

  @SuppressWarnings("unchecked")
  @Execute(validator = false)
  public String index() throws FileNotFoundException, IOException, JAXBException,
      TransformerException, SAXException {

    String actionId = this.request.getParameter(Constants.ACTION_ID);
    Action action = this.config.getActions().get(actionId);

    // FIXME 画面入力値をセッションから仮取得
    Map<String, String> screenMap = (Map<String, String>) this.session
        .getAttribute(Constants.SCREEN_MAP_KEY);

    // FIXME 衝突のチェック時のDB値をセッションから仮取得
    Map<String, String> dbMap = (Map<String, String>) this.session
        .getAttribute(Constants.DB_MAP_KEY);

    // FIXME 画面オープン時の値をセッションから仮取得
    Map<String, String> onOpenMap = (Map<String, String>) this.session
        .getAttribute(Constants.OPEN_MAP_KEY);

    String[] overwrites = this.request.getParameterValues("overwrite");

    for (String field : screenMap.keySet()) {
      String dbValue = dbMap.containsKey(field) ? dbMap.get(field) : "";
      String screenValue = screenMap.containsKey(field) ? screenMap.get(field) : "";
      String openValue = onOpenMap.containsKey(field) ? onOpenMap.get(field) : "";

      if (!StringUtils.equals(openValue, dbValue) && !StringUtils.equals(openValue, screenValue)
          && !StringUtils.equals(dbValue, screenValue)) {

        // 衝突したフィールドのうち・・・、
        if (ArrayUtils.contains(overwrites, field)) {
          // 調整画面において、画面入力値で上書きする選択がされた
          this.saveForm.paramMap.put(field, new String[] { screenValue });

        } else {
          // 調整画面において、画面入力値で上書きする選択がされなかった（<-DB値をそのままにしておくことを示す）
          this.saveForm.paramMap.put(field, new String[] { dbValue });
        }

      }

    }

    // FIXME 衝突したフィールドのうち、画面入力値を有効にするフィールドをセッションに仮保存
    this.session.setAttribute(Constants.CONF_VALID_KEY, overwrites);

    // FIXME 衝突のチェック時のDB値をセッションに仮保存
    this.session.setAttribute(Constants.LAST_DB_MAP_KEY, dbMap);

    return "/stx/saveDispatch?formId=" + action.getFormConfig().getId() + "&actionId="
        + action.getMethod();

  }

}
