package jp.co.epson.watch.plaWasabi.action.stx.kikaku;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;

import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;

import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;
import jp.co.fit.stx.servercomponent.core.SQLImporter;
import jp.co.fit.stx.servercomponent.core.SQLImporterIF;

import org.seasar.struts.annotation.Execute;
import org.xml.sax.SAXException;

public class ListboxSampleAction {

  @Resource
  private ServletContext context;

  @Resource
  private HttpServletRequest request;

  @Resource
  private HttpServletResponse response;

  @Execute(validator = false)
  public String index() {
    String htmlFile = "/stx/kikaku/listboxSample_i.htm";
    String vrqFile = "/vrq/brand.vrq";
    // String vrqFile = "/vrq/waterproof.vrq";

    Connection con = getJDBCConnect("oracle.jdbc.driver.OracleDriver",
        "jdbc:oracle:thin:@localhost:1521:XE", "wasabi", "wasabi");

    String ctxt = this.context.getRealPath("/");

    try {
      // テンプレートHTML
      FileInputStream html = new FileInputStream(ctxt + htmlFile);

      if (con != null) {
        SQLImporterIF sql = new SQLImporter();
        sql.setConnection(con);
        sql.importer(SQLImporterIF.IMPORT_FOR_INPUT, ctxt + vrqFile, (HashMap) this.request
            .getParameterMap(), html, this.response.getOutputStream());
      }

    } catch (FileNotFoundException e) {
      throw new WasabiRuntimeException(e);
    } catch (TransformerException e) {
      throw new WasabiRuntimeException(e);
    } catch (IOException e) {
      throw new WasabiRuntimeException(e);
    } catch (SAXException e) {
      throw new WasabiRuntimeException(e);
    }

    return null;

  }

  /**
   * JDBC接続でConnectionを生成する
   * 
   * @return Connection
   */
  private Connection getJDBCConnect(String className, String url, String userid, String password) {
    Connection rv = null;
    try {
      Class.forName(className);
      rv = DriverManager.getConnection(url, userid, password);
    } catch (NullPointerException e) {
      e.printStackTrace();
    } catch (ClassNotFoundException e) {
      e.printStackTrace();
    } catch (SQLException e) {
      e.printStackTrace();
    }
    return rv;
  }
}
