package jp.co.epson.watch.plaWasabi.action.stx.kikakuMain2;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;
import jp.co.epson.watch.plaWasabi.service.straForm.StraFormService;
import jp.co.epson.watch.plaWasabi.service.svf.PDFService;

import org.seasar.struts.annotation.Execute;

public class IndexAction {

  @Resource
  private HttpServletRequest request;

  @Resource
  private ServletContext context;

  @Resource
  private HttpServletResponse response;

  @Resource
  private StraFormService straFormService;

  @Resource
  private PDFService pdfService;

  private static final String PATH_SUFFIX = "stx/kikakuMain2/";

  private static final String XSL_FILE = PATH_SUFFIX + "kikakuMain.xsl";

  @SuppressWarnings("unchecked")
  @Execute(validator = false)
  // @AcLog(aplCd = "kikaku_main", aplName = "企画No管理表(PDF出力)", accessType =
  // "PDF")
  public String pdf() {

    // リクエストパラメータからXMLを取得する
    InputStream xmlIs = this.straFormService.getParameterXml(new HashMap<String, String[]>(
        this.request.getParameterMap()), XSL_FILE);

    try {
      String formFile = this.context.getRealPath("svfForm/kikakuMain.xml");

      this.response.setHeader("Content-Disposition", "attachment;filename=result.pdf");
      this.response.setHeader("Cache-Control", "private");
      this.response.setContentType("application/pdf");
      OutputStream pdfOs = this.response.getOutputStream();
      int ret = this.pdfService.previewPDF(xmlIs, pdfOs, formFile, "localhost", 44080, "JOB005");
      this.response.setContentLength(ret);
      pdfOs.close();

    } catch (Exception e) {
      throw new WasabiRuntimeException(e);
    }

    return null;

  }
}
