package jp.co.epson.watch.plaWasabi.converter.prmMapKey;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.epson.watch.plaWasabi.commons.Constants;

public class MsAqBandPrmConverter implements PrmConverter {

  @SuppressWarnings("unchecked")
  @Override
  public Map<String, String[]> convert(List<Map> src) {
    Map<String, String[]> res = new HashMap<String, String[]>();

    if (src != null) {
      Integer mbColNum = 1;
      Integer lbColNum = 4;
      Integer rbColNum = 6;
      for (Map<String, Object> row : src) {

        Integer colNum;
        String bandType = (String) row.get("skkb174");
        if (Constants.BAND_TYPE_MB.equals(bandType)) {
          colNum = mbColNum;
        } else if (Constants.BAND_TYPE_LB.equals(bandType)) {
          colNum = lbColNum;
        } else if (Constants.BAND_TYPE_RB.equals(bandType)) {
          colNum = rbColNum;
        } else {
          colNum = mbColNum;
        }

        for (String key : row.keySet()) {
          Object value = row.get(key);
          res.put(key + Constants.COL_SUFFIX + colNum, new String[] { value != null ? value
              .toString() : "" });
        }

        if (Constants.BAND_TYPE_MB.equals(bandType)) {
          mbColNum++;
        } else if (Constants.BAND_TYPE_LB.equals(bandType)) {
          lbColNum++;
        } else if (Constants.BAND_TYPE_RB.equals(bandType)) {
          rbColNum++;
        } else {
          mbColNum++;
        }
      }
    }

    return res;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Map<String, String[]> convert(Map src) {
    List<Map> tmp = new ArrayList<Map>();
    tmp.add(src);

    return this.convert(tmp);
  }

}
