package jp.co.epson.watch.plaWasabi.converter.prmMapKey;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.co.epson.watch.plaWasabi.commons.Constants;

public class RowPrmConverter implements PrmConverter {

  @SuppressWarnings("unchecked")
  @Override
  public Map<String, String[]> convert(List<Map> src) {
    Map<String, String[]> res = new HashMap<String, String[]>();

    if (src != null) {
      int rowNum = 1;
      for (Map<String, Object> row : src) {

        for (String key : row.keySet()) {
          Object value = row.get(key);
          res.put(key + Constants.ROW_SUFFIX + rowNum, new String[] { value != null ? value
              .toString() : "" });
        }

        rowNum++;
      }
    }

    return res;

  }

  @SuppressWarnings("unchecked")
  @Override
  public Map<String, String[]> convert(Map src) {
    Map<String, String[]> res = new HashMap<String, String[]>();

    if (src != null) {
      for (String key : ((Map<String, Object>) src).keySet()) {
        Object value = src.get(key);
        res.put(key, new String[] { value != null ? value.toString() : "" });
      }
    }

    return res;
  }

}
