package jp.co.epson.watch.plaWasabi.entity;

import java.math.BigInteger;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

/**
 * ChangeLogエンティティクラス
 * 
 * @author S2JDBC-Gen
 */
@Entity
public class ChangeLog {

    /** seqプロパティ */
    @Id
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "generator")
    @TableGenerator(name = "generator", initialValue = 0, allocationSize = 1)
    @Column(precision = 22, nullable = false, unique = true)
    public BigInteger seq;

    /** aplCdプロパティ */
    @Column(length = 64, nullable = false, unique = false)
    public String aplCd;

    /** aplSeqプロパティ */
    @Column(precision = 22, nullable = false, unique = false)
    public BigInteger aplSeq;

    /** userIdプロパティ */
    @Column(length = 32, nullable = false, unique = false)
    public String userId;

    /** changeTimeプロパティ */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(nullable = false, unique = false)
    public Date changeTime;

    /** updatedContentプロパティ */
    @Column(length = 2048, nullable = true, unique = false)
    public String updatedContent;
}