package jp.co.epson.watch.plaWasabi.service;

import java.util.List;
import jp.co.epson.watch.plaWasabi.entity.IdGenerator;

import static jp.co.epson.watch.plaWasabi.entity.IdGeneratorNames.*;
import static org.seasar.extension.jdbc.operation.Operations.*;

/**
 * {@link IdGenerator}のサービスクラスです。
 * 
 * @author S2JDBC-Gen
 */
public class IdGeneratorService extends AbstractService<IdGenerator> {

    /**
     * 識別子でエンティティを検索します。
     * 
     * @param pk
     *            識別子
     * @return エンティティ
     */
    public IdGenerator findById(String pk) {
        return select().id(pk).getSingleResult();
    }

    /**
     * 識別子の昇順ですべてのエンティティを検索します。
     * 
     * @return エンティティのリスト
     */
    public List<IdGenerator> findAllOrderById() {
        return select().orderBy(asc(pk())).getResultList();
    }
}