package jp.co.epson.watch.plaWasabi.service.straForm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletContext;
import javax.xml.transform.TransformerException;

import jp.co.epson.watch.plaWasabi.commons.WasabiRuntimeException;
import jp.co.fit.stx.servercomponent.core.XmlExporter;
import jp.co.fit.stx.servercomponent.core.XmlExporterIF;
import jp.co.fit.stx.servercomponent.core.XmlImporter;
import jp.co.fit.stx.servercomponent.core.XmlImporterIF;

import org.apache.commons.io.IOUtils;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.xml.sax.SAXException;

public class StraFormService {

  @Binding
  private ServletContext context;

  /**
   * HTMLをレンダリングする
   * 
   * @param importType
   *          編集画面(XmlImporter.IMPORT_FOR_INPUT） or
   *          読専画面（XmlImporter.IMPORT_FOR_REFER）
   * @param dataMap
   *          画面出力データ
   * @param htmlFile
   *          HTMLファイル名（コンテキストルートからの相対パス）
   * @param xslFile
   *          XSLファイル名（コンテキストルートからの相対パス）
   * @param eraseFields
   *          画面から除去するコントロール名
   * @param labelFields
   *          ラベル化するコントロール名
   * @param os
   *          出力先
   */
  public void renderHtml(int importType, Map<String, String[]> dataMap, String htmlFile,
      String xslFile, String[] eraseFields, String[] labelFields, OutputStream os) {

    try {
      if (dataMap == null || dataMap.size() == 0) {
        dataMap = new HashMap<String, String[]>();
        dataMap.put("", new String[] { "" }); // Tips
        // Mapが何らかの値を持っていないとXMLを作ってくれない
      }

      String xslFileName = this.context.getRealPath("/") + xslFile;
      InputStream xslIs = new ByteArrayInputStream(IOUtils.toByteArray(new FileInputStream(
          xslFileName)));
      InputStream[] xsls = new InputStream[] { xslIs };

      XmlExporterIF xe = new XmlExporter();
      ByteArrayOutputStream xmlOs = new ByteArrayOutputStream();
      xe.exporter(new HashMap<String, String[]>(dataMap), xsls, null, new OutputStream[] { xmlOs });
      xslIs.reset();

      InputStream xmlIs = new ByteArrayInputStream(xmlOs.toByteArray());
      InputStream[] xmls = new InputStream[] { xmlIs };

      String htmlFileName = this.context.getRealPath("/") + htmlFile;
      InputStream htmlIs = new FileInputStream(htmlFileName);

      XmlImporterIF xi = new XmlImporter();
      xi.importer(importType, xmls, xsls, htmlIs, os, eraseFields, labelFields);

    } catch (FileNotFoundException e) {
      throw new WasabiRuntimeException(e);
    } catch (IOException e) {
      throw new WasabiRuntimeException(e);
    } catch (TransformerException e) {
      throw new WasabiRuntimeException(e);
    } catch (SAXException e) {
      throw new WasabiRuntimeException(e);
    }

  }

  /**
   * XmlExporterを使って、リクエストパラメータからXMLを取得する
   * 
   * @param paramMap
   *          リクエストパラメータ
   * @param xslFile
   *          XSLファイル名（コンテキストルートからの相対パス）
   * @return データXMLのInputStream
   */
  public InputStream getParameterXml(HashMap<String, String[]> paramMap, String xslFile) {

    try {
      String xslFileName = this.context.getRealPath("/") + xslFile;
      InputStream xslIs = new FileInputStream(xslFileName);

      // 画面に入力した値を取得
      XmlExporterIF xe = new XmlExporter();
      ByteArrayOutputStream xmlOs = new ByteArrayOutputStream();
      InputStream[] xsls = new InputStream[] { xslIs };
      xe.exporter(paramMap, xsls, null, new OutputStream[] { xmlOs });

      xslIs.close();
      InputStream xmlIs = new ByteArrayInputStream(xmlOs.toByteArray());
      return xmlIs;

    } catch (FileNotFoundException e) {
      throw new WasabiRuntimeException(e);
    } catch (IOException e) {
      throw new WasabiRuntimeException(e);
    }

  }

  public Map<String, String> convertParamMap2Map(Map<String, String[]> src) {
    Map<String, String> res = new HashMap<String, String>();

    for (String key : src.keySet()) {
      String[] vals = src.get(key);
      if (vals != null && vals.length > 0) {
        res.put(key, vals[0]);
      }
    }

    return res;
  }

}