package jp.co.epson.watch.plaWasabi.test.service;

import java.io.InputStream;

import jp.co.epson.watch.plaWasabi.dto.formConfig.Action;
import jp.co.epson.watch.plaWasabi.dto.formConfig.ActionQuery;
import jp.co.epson.watch.plaWasabi.dto.formConfig.EntityMapping;
import jp.co.epson.watch.plaWasabi.dto.formConfig.ExcelForm;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Form;
import jp.co.epson.watch.plaWasabi.dto.formConfig.FormConfig;
import jp.co.epson.watch.plaWasabi.dto.formConfig.PdfForm;
import jp.co.epson.watch.plaWasabi.dto.formConfig.Query;
import jp.co.epson.watch.plaWasabi.service.form.FormService;

import org.junit.Assert;
import org.junit.Test;

public class FormServiceTest {

  private FormService formService = new FormService();

  @Test
  public void testReadMsAq() throws Exception {
    String formId = "ms-aq";
    InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(
        "config/" + formId + ".xml");
    FormConfig fc = this.formService.loadFormConfig(is, formId);
    Assert.assertEquals(formId, fc.getId());

    Action a1 = fc.getActions().get("disp");
    Assert.assertNotNull(a1);

    ActionQuery unitQ = a1.getQueryMap().get("unit");
    Assert.assertNotNull(unitQ);
    Assert.assertEquals("", unitQ.getPrmConverter());

    ActionQuery bandQ = a1.getQueryMap().get("band");
    Assert.assertNotNull(bandQ);
    Assert.assertEquals("msAqBandPrmConverter", bandQ.getPrmConverter());

  }

  @Test
  public void testReadBandList() throws Exception {
    String formId = "band-list";
    InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(
        "config/" + formId + ".xml");
    FormConfig fc = this.formService.loadFormConfig(is, formId);
    Assert.assertEquals(formId, fc.getId());
  }

  @Test
  public void testReadPlanMod() throws Exception {
    String formId = "plan-mod";
    InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(
        "config/" + formId + ".xml");
    FormConfig fc = this.formService.loadFormConfig(is, formId);
    Assert.assertEquals(formId, fc.getId());

    Assert.assertEquals(1, fc.getPdfForms().size());
    PdfForm pdf1 = fc.getPdfForms().get("plan-mod");
    Assert.assertNotNull(pdf1);
    Assert.assertEquals("svfForm/plan-mod.xml", pdf1.getFormFile());
    Assert.assertEquals(2, pdf1.getFileNameParams().size());
    Assert.assertEquals("kika002", pdf1.getFileNameParams().get(0));

    Action a1 = fc.getActions().get("disp");
    Assert.assertNotNull(a1);
    Assert.assertEquals(2, a1.getQueryMap().size());

    ActionQuery q1 = a1.getQueryMap().get("unit");
    Assert.assertNotNull(q1);
    ActionQuery q2 = a1.getQueryMap().get("changeHistory");
    Assert.assertNotNull(q2);

    Assert.assertEquals(1, q1.getQueryParams().size());
    Assert.assertEquals(2, q2.getQueryParams().size());

    Action a2 = fc.getActions().get("pdf");
    Assert.assertNotNull(a2);
    Assert.assertNotNull(a2.getPdfForm());
    Assert.assertEquals("plan-mod", a2.getPdfForm().getId());

  }

  @Test
  public void testReadKikakuMain() throws Exception {
    String formId = "kikaku-main";
    InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(
        "config/" + formId + ".xml");
    FormConfig fc = this.formService.loadFormConfig(is, formId);
    Assert.assertEquals(formId, fc.getId());

    Query q = fc.getQueries().get("list");
    Assert.assertTrue(q.getQuery().contains("select"));

    EntityMapping em = fc.getEntityMappings().get("save");
    Assert.assertEquals("KIKAKU", em.getEntities().get(0));

    Form form = fc.getForms().get("kikakuMain");
    Assert.assertEquals("stx/kikakuMain/kikakuMain.xsl", form.getXslFile());
    Assert.assertEquals("kika000d", form.getLabelFields().get(0));

    ExcelForm excleForm = fc.getExcelForms().get("list");
    Assert.assertEquals("kika002", excleForm.getFields().get(0));
    Assert.assertEquals("kika216", excleForm.getFields().get(7));

    Action a1 = fc.getActions().get("listSearch");
    Assert.assertEquals("kikakuMain", a1.getForm().getId());
    Assert.assertNotNull(a1.getQueryMap());
    ActionQuery actionQuery1 = a1.getQueryMap().get("list");
    Assert.assertNotNull(actionQuery1);
    Assert.assertTrue(actionQuery1.isPrimary());
    Assert.assertEquals("listSearch", actionQuery1.getAction().getMethod());
    Assert.assertNotNull(actionQuery1.getQueryParams());
    Assert.assertEquals("kika002_cond", actionQuery1.getQueryParams().get(0).getId());
    Assert.assertEquals(formId, a1.getFormConfig().getId());

    Action a3 = fc.getActions().get("persist");
    Assert.assertNotNull(a3.getEntityMapping());
    Assert.assertNotNull(a3.getEntityMapping().getEntities());
    Assert.assertEquals("KIKAKU", a3.getEntityMapping().getEntities().get(0));

    Action a4 = fc.getActions().get("excel");
    Assert.assertNotNull(a4.getExcelForm());
    Assert.assertNotNull(a4.getExcelForm().getFields());
    Assert.assertEquals("kika002", a4.getExcelForm().getFields().get(0));

    Action a5 = fc.getActions().get("listDelete");
    Assert.assertNotNull(a5.getDeleteQuery());
    Assert.assertNotNull(a5.getDeleteQuery().getQuery());
    Assert.assertTrue(a5.getDeleteQuery().getQuery().contains("delete"));

  }

}