package jp.co.epson.watch.plaWasabi.test.service.excel;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.co.epson.watch.plaWasabi.dto.formConfig.Action;
import jp.co.epson.watch.plaWasabi.dto.formConfig.FormConfig;
import jp.co.epson.watch.plaWasabi.service.DbService;
import jp.co.epson.watch.plaWasabi.service.excel.ExcelService;
import jp.co.epson.watch.plaWasabi.service.excel.FieldDef;
import jp.co.epson.watch.plaWasabi.service.excel.FieldsDef;
import jp.co.epson.watch.plaWasabi.service.form.FormService;
import jp.co.epson.watch.plaWasabi.service.schema.oracle.CacheManagerService;

import org.junit.Test;
import org.seasar.extension.unit.S2TestCase;

public class ExcelTest extends S2TestCase {

  @Resource
  private ExcelService excelService;

  @Resource
  private FormService formService;

  @Resource
  private DbService dbService;

  @Resource
  private CacheManagerService cacheManagerService;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    include("app.dicon");
  }

  @SuppressWarnings("unchecked")
  @Test
  public void test001() throws Exception {

    OutputStream os = new FileOutputStream("c:/sample1.xls");

    String[] flds = new String[] { "kika002", "kika101", "kika133", "kika020", "kika011",
        "kika201", "kika017", "kika216" };

    FieldsDef fieldsDef = new FieldsDef();
    int colNum = 0;
    for (String fld : flds) {
      FieldDef def = new FieldDef();
      def.id = fld;
      def.name = this.cacheManagerService.getColumn(fld).getComment();
      fieldsDef.addField(colNum++, def);
    }

    FormConfig conf = this.formService.loadFormConfig("kikaku-main");
    Action action = conf.getActions().get("excel");
    String sql = action.getPrimaryActionQuery().getQuery().getQuery();

    List<Map> resList = this.dbService.selectBySql(sql, new String[] { "98E%" });

    this.excelService.createXlsBook(fieldsDef, resList, os);

    os.close();
  }

}
