package jp.co.epson.watch.plaWasabi.test.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import junit.framework.Assert;

import org.apache.commons.beanutils.BeanUtils;
import org.junit.Test;
import org.seasar.framework.beans.util.BeanUtil;

public class BeanUtilsTest {

  @Test
  public void test001() throws IllegalAccessException, InvocationTargetException,
      NoSuchMethodException {
    Map<String, String> src = new HashMap<String, String>();
    src.put("kika000", "zzz");

    // 正しくコピーされる
    Dest dest = new Dest();
    BeanUtil.copyProperties(src, dest);
    Assert.assertEquals(src.get("kika000"), dest.kika000);

    // 正しくコピーされない
    Map<String, String> destMap = new HashMap<String, String>();
    BeanUtil.copyProperties((Object) src, destMap);
    Assert.assertNull(destMap.get("kika000"));

    // 正しくコピーされない
    Dest dest1 = new Dest();
    BeanUtils.copyProperties(dest1, src);
    Assert.assertNull(dest1.kika000);

  }

  class Dest {
    public String kika000;
  }

}
