package jp.ac.titech.sharp4k.cuten;

import java.util.ArrayList;
import java.util.Arrays;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

public class Achievement {
	private Task task;
	private int[] result;
	private int submitted;

	public Achievement(Task task, String result) {
		this.task = task;
		setResultString(result);
		submitted = 0;
	}

	public Achievement(Task task, int[] result) {
		this.task = task;
		this.result = result;
		submitted = 0;
	}

	public Task getTask() {
		return task;
	}

	public int[] getResultArray() {
		return result;
	}

	public boolean getSubmitted() {
		return submitted == 1;
	}

	public String getResultString() {
		StringBuilder str = new StringBuilder(result.length * 3);
		for (int i = 0; i < result.length; i++) {
			if (i != 0) {
				str.append(',');
			}
			str.append(String.valueOf(result[i]));
		}
		return String.valueOf(str);
	}

	private void setResultString(String result) {
		String[] temp = result.split(",", -1);
		this.result = new int[temp.length];
		for (int i = 0; i < temp.length; i++) {
			try {
				this.result[i] = Integer.parseInt(temp[i]);
			} catch (NumberFormatException e) {
				this.result[i] = 0;
			}
		}
	}

	public void setResult(int[] result) {
		this.result = result;
	}

	public void setSubmitted(boolean submitted) {
		if (submitted) {
			this.submitted = 1;
		} else {
			this.submitted = 0;
		}
	}

	public static ArrayList<Achievement> findNotSubmitted(SQLiteDatabase db) {
		ArrayList<Achievement> ret = new ArrayList<Achievement>();
		Cursor c = db.rawQuery("SELECT result,task_id" + " FROM achievements"
				+ " WHERE submitted = ?", new String[] { String.valueOf(0) });
		while (c.moveToNext()) {
			int taskId = c.getInt(1);
			ret.add(new Achievement(Task.find(db, taskId), c.getString(0)));
		}
		return ret;
	}

	public long replace(SQLiteDatabase db) {
		ContentValues row = new ContentValues();
		row.put("task_id", getTask().getId());
		row.put("result", getResultString());
		row.put("submitted", submitted);
		return db.insertWithOnConflict("achievements", null, row,
				SQLiteDatabase.CONFLICT_REPLACE);
	}

	// oldに新しい成績aをマージする
	// その際に変更した数を返す
	private int merge(int[] old, int[] a) {
		int change = 0;
		int n = old.length;
		if (old.length != a.length) {
			return 0;
		}
		for (int i = 0; i < n; i++) {
			if (a[i] > old[i]) {
				old[i] = a[i];
				change++;
			}
		}
		return change;
	}

	public boolean merge(SQLiteDatabase db) {
		Cursor c = db.rawQuery("SELECT result,submitted" + " FROM achievements"
				+ " WHERE task_id = ?",
				new String[] { String.valueOf(task.getId()) });
		if (c.moveToNext()) {
			Achievement old = new Achievement(task, c.getString(0));
			boolean submitted = (c.getInt(1) == 1);
			// 成績の改善によるマージ
			int changeCount = merge(old.result, result);
			if (changeCount > 0) {
				this.result = old.result;
				this.replace(db);
				return true;
			} else {
				// 送信済みフラグの変更によるマージ
				if (submitted == false && this.submitted == 1) {
					// 成績が同じ場合にはマージ
					if (Arrays.equals(old.result, result)) {
						this.replace(db);
					}
				}
				return false;
			}
		} else {
			// not found
			this.replace(db);
			return true;
		}
	}

	public static Achievement find(SQLiteDatabase db, Task task) {
		Cursor c = db.rawQuery("SELECT result" + " FROM achievements"
				+ " WHERE task_id = ?",
				new String[] { String.valueOf(task.getId()) });
		if (c.moveToNext()) {
			return new Achievement(task, c.getString(0));
		} else {
			// not found
			return null;
		}
	}

	public static Achievement find(SQLiteDatabase db, int taskId) {
		return Achievement.find(db, Task.find(db, taskId));
	}
}
