package jp.ac.titech.sharp4k.cuten;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.apache.http.StatusLine;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

public class AchievementsSenderTask implements Runnable {
	private static final String TAG = AchievementsSenderTask.class
			.getSimpleName();
	private final ScheduledExecutorService executor;
	private final Context context;
	private final BlockingQueue<Achievement> queue;
	private final HttpAPIClient apiClient;

	private static final int RETRY_PERIOD_SEC = 5;

	public AchievementsSenderTask(ScheduledExecutorService executor,
			Context context, BlockingQueue<Achievement> queue,
			HttpAPIClient apiClient) {
		this.executor = executor;
		this.context = context;
		this.queue = queue;
		this.apiClient = apiClient;
	}

	public void send(final Achievement achievement) {
		Log.d(TAG,
				"Sending achievement task_id=" + achievement.getTask().getId()
						+ ", result=" + achievement.getResultString());
		apiClient.putAchievement(Token.load(context), achievement,
				new SimpleHttpResponseListener() {
					@Override
					public void onSuccess(String body) {
						// データベース読み取りor作成
						SQLiteOpenHelper h = new SQLHelper(context);
						final SQLiteDatabase db = h.getReadableDatabase();
						// DBとデータをマージ
						achievement.setSubmitted(true);
						achievement.merge(db);
						db.close();
						Log.d(TAG, "Sent achievement task_id="
								+ achievement.getTask().getId() + ", result="
								+ achievement.getResultString());
						succeeded();
					}

					@Override
					public void onFailure(Exception e) {
						Log.e(TAG, "putAchievement:");
						e.printStackTrace();
						failed(achievement);
					}

					@Override
					public void onUnauthorized() {
						Log.e(TAG, "putAchievement: unauthorized");
						failed(achievement);
					}

					@Override
					public void onHttpFailure(StatusLine status, String body) {
						Log.e(TAG,
								"putAchievement: returned "
										+ status.getStatusCode());
						failed(achievement);
					}
				});
	}

	@Override
	public void run() {
		try {
			send(queue.take());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void succeeded() {
		executor.schedule(this, 0, TimeUnit.SECONDS);
	}

	private void failed(Achievement a) {
		AchievementsSender.add(a);
		executor.schedule(this, RETRY_PERIOD_SEC, TimeUnit.SECONDS);
	}
}
