package jp.ac.titech.sharp4k.cuten;

import java.util.List;

import org.apache.http.StatusLine;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ListView;
import android.widget.TextView;

import com.google.inject.Inject;

public class DownloadActivity extends BaseMenuActivity {
	private static final String TAG = DownloadActivity.class.getSimpleName();

	@Inject
	private HttpAPIClient apiClient;
	private List<Lecture> haveLecture, newLecture;
	private TextView tv;
	private ListView lectureList;
	private ArrayAdapter<String> haveAdapter, newAdapter;
	private ImageButton update, ok, move;
	private Button add, delete;
	private SQLiteDatabase db;
	private ProgressDialog connectingDialog;
	private AlertDialog alertDialog;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.downloadown);

		db = new SQLHelper(this).getWritableDatabase();

		// Viewの取得、ボタンのリスナーセット
		setLayout();
		// サーバからデータを取得
		downloadLectures();
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		if (db != null) {
			db.close();
			db = null;
		}
	}

	private void setLayout() {
		tv = (TextView) findViewById(R.id.textView);
		lectureList = (ListView) findViewById(R.id.lectureList);
		lectureList.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);
		haveAdapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_list_item_multiple_choice);
		newAdapter = new ArrayAdapter<String>(this,
				android.R.layout.simple_list_item_multiple_choice);

		update = (ImageButton) findViewById(R.id.update);
		update.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				downloadLectures();
			}
		});
		add = (Button) findViewById(R.id.add);
		add.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				lectureList.setAdapter(newAdapter);
				tv.setText("登録したい講義を選択し、下の登録ボタンを押してください");
				ok.setImageResource(R.drawable.addcal40);
				ok.setOnClickListener(new OnClickListener() {
					@Override
					public void onClick(View v) {
						for (int i = 0; i < newLecture.size(); i++) {
							if (lectureList.isItemChecked(i)) {
								newLecture.get(i).saveToSelected(db);
								lectureList.setItemChecked(i, false);
							}
						}
						resetAdapter();
					}
				});
			}
		});
		delete = (Button) findViewById(R.id.delete);
		delete.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				lectureList.setAdapter(haveAdapter);
				tv.setText("削除したい講義を選択し、下の削除ボタンを押してください");
				ok.setImageResource(R.drawable.del40);
				ok.setOnClickListener(new OnClickListener() {
					@Override
					public void onClick(View v) {
						for (int i = 0; i < haveLecture.size(); i++) {
							if (lectureList.isItemChecked(i)) {
								haveLecture.get(i).deleteFromSelected(db);
								lectureList.setItemChecked(i, false);
							}
						}
						resetAdapter();
					}
				});
			}
		});
		ok = (ImageButton) findViewById(R.id.ok);
		move = (ImageButton) findViewById(R.id.move);
		move.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});

		// initial mode is 'add'
		add.performClick();

		// プログレスダイアログ(サーバとの通信中に表示)
		connectingDialog = new ProgressDialog(this);
		connectingDialog.setTitle("通信中");
		connectingDialog.setMessage("サーバにアクセスしています・・・");
		connectingDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
		connectingDialog.setCancelable(false);

		// 警告ダイアログ(ネットワークエラー時に表示)
		alertDialog = new AlertDialog.Builder(this).setTitle("警告")
				.setMessage("サーバからデータを取得できませんでした")
				.setPositiveButton("OK", new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
					}
				}).setCancelable(false).create();
	}

	private void downloadLectures() {
		connectingDialog.show();
		apiClient.getLectures(new SimpleHttpResponseListener() {
			@Override
			public void preExec() {
				connectingDialog.dismiss();
			}

			@Override
			public void onSuccess(String body) {
				jsonParse(body);
			}

			@Override
			public void onFailure(Exception e) {
				e.printStackTrace();
				alertDialog.show();
			}

			@Override
			public void onHttpFailure(StatusLine status, String body) {
				Log.e(TAG, "getLectures: returned " + status.getStatusCode());
				alertDialog.show();
			}

			@Override
			public void postExec() {
				resetAdapter();
			}
		});
	}

	// とりあえず全データをデータベースにぶっこむ
	private void jsonParse(String data) {
		try {
			JSONArray root = new JSONArray(data);
			for (int i = 0; i < root.length(); i++) {
				JSONObject lecture = root.getJSONObject(i);
				JSONObject teacher = lecture.getJSONObject("teacher");
				Teacher t = new Teacher(teacher.getInt("id"),
						teacher.getString("name"));
				Lecture l = new Lecture(lecture.getInt("id"),
						lecture.getString("name"), t);
				t.save(db);
				l.save(db);
			}
		} catch (JSONException e) {
			e.printStackTrace();
		}
	}

	// selected_lecturesの情報をもとに、未登録と登録済みの講義を分別する
	private void resetAdapter() {
		haveLecture = Lecture.findSelectedAll(db);
		newLecture = Lecture.findUnselectedAll(db);

		haveAdapter.clear();
		for (Lecture l : haveLecture) {
			haveAdapter.add(l.getName());
		}
		haveAdapter.notifyDataSetChanged();

		newAdapter.clear();
		for (Lecture l : newLecture) {
			newAdapter.add(l.getName());
		}
		newAdapter.notifyDataSetChanged();
	}
}
