package jp.ac.titech.sharp4k.cuten.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import jp.ac.titech.sharp4k.cuten.Lecture;
import jp.ac.titech.sharp4k.cuten.LectureFolder;
import jp.ac.titech.sharp4k.cuten.SQLHelper;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlSerializer;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import android.util.Xml;

public class XmlUtility {

	public static final String fileName = "folder.xml";

	private static final String FOLDER_TAG_NAME = "folder";
	private static final String FOLDER_ATTRIBUTE_NAME = "name";
	private static final String DEFAULT_FOLDER_ATTRIBUTE = "default";
	private static final String LECTURE_TAG_NAME = "lecture";
	private static final String DOCUMENT_TAG_NAME = "document";

	public static List<LectureFolder> readXmlFile(Context context) {
		List<LectureFolder> folList = new ArrayList<LectureFolder>();

		SQLHelper sqlHelper = new SQLHelper(context);
		SQLiteDatabase database = sqlHelper.getReadableDatabase();

		try {
			XmlPullParser parser = Xml.newPullParser();

			InputStream is = context.openFileInput(fileName);
			InputStreamReader reader = new InputStreamReader(is);
			parser.setInput(reader);

			LectureFolder folder = null;

			for (int type = parser.getEventType(); type != XmlPullParser.END_DOCUMENT; type = parser
					.next()) {
				switch (type) {
				case XmlPullParser.START_TAG: {
					Log.d(FOLDER_TAG_NAME, parser.getName());
					if (parser.getName().equals(FOLDER_TAG_NAME)) {
						String title = parser.getAttributeValue("",
								FOLDER_ATTRIBUTE_NAME);
						folder = new LectureFolder(title);

						if (parser.getAttributeValue("",
								DEFAULT_FOLDER_ATTRIBUTE) != null) {
							folder.setDefault();
						}
					} else if (parser.getName().equals(LECTURE_TAG_NAME)) {
					}
					break;
				}
				case XmlPullParser.TEXT: {
					Lecture lec = Lecture.find(database,
							Integer.valueOf(parser.getText()));
					folder.add(lec);
					break;
				}
				case XmlPullParser.END_TAG: {
					if (parser.getName().equals(FOLDER_TAG_NAME)) {
						folList.add(folder);
					} else if (parser.getName().equals(LECTURE_TAG_NAME)) {
						// ここにidからLectureを引く動作をついかする
					}
					break;
				}
				}
			}
		} catch (FileNotFoundException e) {
			// ignore
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			database.close();
		}

		return folList;
	}

	public static void writeXmlFile(Context context, List<LectureFolder> folders) {

		try {
			XmlSerializer serializer = Xml.newSerializer();

			FileOutputStream os = context.openFileOutput(fileName,
					Context.MODE_PRIVATE);
			serializer.setOutput(os, "UTF-8");

			serializer.startDocument("UTF-8", true);
			// データ入力
			serializer.startTag("", DOCUMENT_TAG_NAME);

			for (int i = 0; i < folders.size(); i++) {
				LectureFolder fol = folders.get(i);
				List<Lecture> lecList = fol.getLectures();

				serializer.startTag("", FOLDER_TAG_NAME);
				Log.d("Lecture", FOLDER_TAG_NAME);
				serializer.attribute("", FOLDER_ATTRIBUTE_NAME, fol.getTitle());
				if (fol.isDefault()) {
					serializer.attribute("", DEFAULT_FOLDER_ATTRIBUTE,
							DEFAULT_FOLDER_ATTRIBUTE);
					Log.d("Attribute", DEFAULT_FOLDER_ATTRIBUTE);
				}
				Log.d("Lecture", fol.getTitle());

				for (int j = 0; j < lecList.size(); j++) {
					Lecture lecture = lecList.get(j);

					serializer.startTag("", LECTURE_TAG_NAME);
					Log.d("Lecture", LECTURE_TAG_NAME);
					int lectureId = lecture.getId();

					serializer.text(String.valueOf(lectureId));
					Log.d("TEXT", String.valueOf(lectureId));

					serializer.endTag("", LECTURE_TAG_NAME);
					Log.d("END", LECTURE_TAG_NAME);
				}
				serializer.endTag("", FOLDER_TAG_NAME);
				Log.d("END", FOLDER_TAG_NAME);
			}

			serializer.endTag("", DOCUMENT_TAG_NAME);
			serializer.endDocument();
			// ファイルに出力
			serializer.flush();

			os.close();
			Log.d("Lecture", "writeOK!");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
