class LecturesController < ApplicationController
  # GET /lectures
  # GET /lectures.json
  def index
    if params[:ids] and params[:ids].is_a? Array
      @lectures = Lecture.where :id => params[:ids]
      render json: @lectures.as_json(:methods => [:tasks])
    else
      @lectures = Lecture.all
      render json: @lectures
    end
  end

  # GET /lectures/new
  def new
    if user_signed_in?
      respond_to do |format|
        format.html { redirect_to root_path, :alert => I18n.t('teacher.not') }
      end
    else
      authenticate_teacher!
      @lecture = Lecture.new
      @lecture.teacher = current_teacher

      respond_to do |format|
        format.html # new.html.haml
      end
    end
  end

  # POST /lectures
  def create
    respond_to do |format|
      if user_signed_in?
        format.html { redirect_to root_path, :alert => I18n.t('teacher.not') }
      else
        authenticate_teacher!
        @lecture = Lecture.new params[:lecture]
        @lecture.teacher = current_teacher

        if @lecture.save
          format.html { redirect_to @lecture, :notice => I18n.t('lecture.created') }
        else
          format.html { render :action => 'new' }
        end
      end
    end
  end

  # GET /lectures/1
  # GET /lectures/1.json
  def show
    @lecture = Lecture.find(params[:id])

    respond_to do |format|
      format.html # show.html.haml
      format.json { render :json => @lecture }
    end
  end
end
