class Apk < ActiveRecord::Base
  belongs_to :task
  attr_accessible :name
  attr_protected :revision

  validates_presence_of :task, :name, :revision

  MIME_TYPE = 'application/vnd.android.package-archive'

  include JsonWithoutTimestamps
  def as_json(options = {})
    super options.merge({:except => [:task_id]})
  end

  def self.directory
    "public/apks/#{Rails.env}"
  end

  def path
    "#{self.class.directory}/#{self.id}.apk"
  end

  def store_file(file)
    FileUtils.mkdir_p self.class.directory
    FileUtils.cp file.to_path.to_s, path
  end

  def incr_revision
    self.revision = self.revision + 1
  end
end
