class Task < ActiveRecord::Base
  belongs_to :lecture
  has_many :apks, :order => 'revision DESC'
  attr_accessible :name

  validates_presence_of :lecture, :name

  include JsonWithoutTimestamps
  def as_json(options = {})
    super options.merge({:methods => [:apk], :except => [:lecture_id]})
  end

  def apk
    apks.first
  end

  def achievement(user)
    Achievement.find_by_task_id_and_user_id!(self.id, user.id)
  end

  def all_achievements
    Achievement.where :task_id => self.id
  end
end
