package jp.ac.titech.sharp4k.cuten.sampletask;

import java.util.ArrayList;

import jp.ac.titech.sharp4k.cuten.R;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.FontMetrics;
import android.graphics.Paint.Style;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;

public class MatrixView extends View {
	Context ctx;
	Resources res;
	float width, height;
	int row, col, checkrow, checkcol;
	int[] cAnswer;
	ArrayList<Integer> uAnswer;
	String[] bits;
	ArrayList<Rect> selRects;

	public MatrixView(Context ctx, Resources res) {
		super(ctx);
		setFocusable(true);
		setFocusableInTouchMode(true);
		this.ctx = ctx;
		this.res = res;
		row = res.getInteger(R.integer.row);
		col = res.getInteger(R.integer.col);
		checkrow = res.getInteger(R.integer.checkrow);
		checkcol = res.getInteger(R.integer.checkcol);
		cAnswer = res.getIntArray(R.array.answer);
		uAnswer = new ArrayList<Integer>();
		bits = res.getStringArray(R.array.code);
		selRects = new ArrayList<Rect>();
	}

	@Override
	protected void onSizeChanged(int w, int h, int oldw, int oldh) {
		width = w / (col + 2);
		height = h / (row + 2);
		super.onSizeChanged(w, h, oldw, oldh);
	}

	@Override
	protected void onDraw(Canvas canvas) {
		// draw matrix line
		Paint line = new Paint();
		line.setColor(Color.GRAY);
		for (int i = 1; i < row + 2; i++) {
			canvas.drawLine(width, i * height, width * (col + 1), i * height,
					line);
		}
		for (int i = 1; i < col + 2; i++) {
			canvas.drawLine(i * width, height, i * width, height * (row + 1),
					line);
		}

		// draw checksum line
		Paint cline = new Paint();
		cline.setColor(Color.RED);
		canvas.drawLine(width, checkrow * height, width * (col + 1), checkrow
				* height, cline);
		canvas.drawLine(width, (checkrow + 1) * height, width * (col + 1),
				(checkrow + 1) * height, cline);
		canvas.drawLine(width, checkrow * height, width, (checkrow + 1)
				* height, cline);
		canvas.drawLine(width * (col + 1), checkrow * height,
				width * (col + 1), (checkrow + 1) * height, cline);
		canvas.drawLine(checkcol * width, height, checkcol * width,
				(checkrow + 1) * height, cline);
		canvas.drawLine((checkcol + 1) * width, height, (checkcol + 1) * width,
				(checkrow + 1) * height, cline);
		canvas.drawLine(checkcol * width, height, (checkcol + 1) * width,
				height, cline);
		canvas.drawLine(checkcol * width, (row + 1) * height, (checkcol + 1)
				* width, (row + 1) * height, cline);

		// selRects
		Paint selected = new Paint();
		selected.setColor(Color.CYAN);
		for (int i = 0; i < selRects.size(); i++) {
			canvas.drawRect(selRects.get(i), selected);
		}

		// bits
		Paint foreground = new Paint(Paint.ANTI_ALIAS_FLAG);
		foreground.setColor(Color.GRAY);
		foreground.setStyle(Style.FILL);
		foreground.setTextSize(height * 0.75f);
		foreground.setTextScaleX(width / height);
		foreground.setTextAlign(Paint.Align.CENTER);
		FontMetrics fm = foreground.getFontMetrics();
		float x = width / 2;
		float y = height / 2 - (fm.ascent + fm.descent) / 2;
		for (int i = 1; i < row + 1; i++) {
			for (int j = 1; j < col + 1; j++) {
				canvas.drawText(bits[(i - 1) * col + (j - 1)], j * width + x, i
						* height + y, foreground);
			}
		}
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		if (event.getAction() != MotionEvent.ACTION_DOWN) {
			return super.onTouchEvent(event);
		} else {
			// position
			int selX, selY;
			selX = (int) (event.getX() / width);
			selY = (int) (event.getY() / height);
			if (selX <= 0 || selY <= 0 || selX > col || selY > row
					|| selX == checkcol || selY == checkrow) {
				return true;
			}
			// create Rect
			Rect r = new Rect();
			r.set((int) (selX * width), (int) (selY * height), (int) (selX
					* width + width), (int) (selY * height + height));
			if (!selRects.remove(r)) {
				selRects.add(r);
				uAnswer.add((selY - 1) * col + selX);
			} else {
				uAnswer.remove((Object) ((selY - 1) * col + selX));
			}
			if (bits[(selY - 1) * col + (selX - 1)].equals("0")) {
				bits[(selY - 1) * col + (selX - 1)] = new String("1");
			} else {
				bits[(selY - 1) * col + (selX - 1)] = new String("0");
			}
			invalidate();
		}
		return true;
	}

	public void reset() {
		bits = res.getStringArray(R.array.code);
		uAnswer = new ArrayList<Integer>();
		selRects = new ArrayList<Rect>();
		invalidate();
	}

	public int finish() {
		boolean check;
		if (uAnswer.size() == cAnswer.length) {
			for (int i = 0; i < cAnswer.length; i++) {
				check = false;
				for (int j = 0; j < uAnswer.size(); j++) {
					if (cAnswer[i] == uAnswer.get(j)) {
						check = true;
					}
				}
				if (!check) {
					return 0;
				}
			}
			return 100;
		}
		return 0;
	}
}